/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui.panels;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.NotificationType;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.notifications.GameMessage;
import com.adamk33n3r.runelite.watchdog.notifications.Notification;
import com.adamk33n3r.runelite.watchdog.notifications.NotificationEvent;
import com.adamk33n3r.runelite.watchdog.notifications.Overhead;
import com.adamk33n3r.runelite.watchdog.notifications.Overlay;
import com.adamk33n3r.runelite.watchdog.notifications.ScreenFlash;
import com.adamk33n3r.runelite.watchdog.notifications.Sound;
import com.adamk33n3r.runelite.watchdog.notifications.SoundEffect;
import com.adamk33n3r.runelite.watchdog.notifications.TextToSpeech;
import com.adamk33n3r.runelite.watchdog.notifications.TrayNotification;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.StretchedStackedLayout;
import com.adamk33n3r.runelite.watchdog.ui.dropdownbutton.DropDownButtonFactory;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.MessageNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.NotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.OverheadNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.OverlayNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.ScreenFlashNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.SoundEffectNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.SoundNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.notifications.panels.TextToSpeechNotificationPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import com.adamk33n3r.runelite.watchdog.ui.panels.ScrollablePanel;
import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.components.DragAndDropReorderPane;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NotificationsPanel.class);
    private final Alert alert;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    private AlertManager alertManager;
    private final DragAndDropReorderPane notificationContainer;

    public NotificationsPanel(Alert alert) {
        this.alert = alert;
        this.setLayout(new BorderLayout(0, 5));
        this.notificationContainer = new DragAndDropReorderPane();
        this.notificationContainer.addDragListener(c -> {
            int pos = this.notificationContainer.getPosition(c);
            NotificationPanel notificationPanel = (NotificationPanel)c;
            Notification notification = notificationPanel.getNotification();
            notification.getAlert().moveNotificationTo(notification, pos);
            this.alertManager.saveAlerts();
        });
        JPopupMenu popupMenu = new JPopupMenu();
        ActionListener actionListener = e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            NotificationType nType = (NotificationType)((Object)((Object)menuItem.getClientProperty(NotificationType.class)));
            this.addPanel(this.createNotification(nType));
            this.notificationContainer.revalidate();
            this.alertManager.saveAlerts();
        };
        Arrays.stream(NotificationType.values()).sorted().forEach(nType -> {
            JMenuItem c = new JMenuItem(nType.getName());
            c.setToolTipText(nType.getTooltip());
            c.putClientProperty(NotificationType.class, nType);
            c.addActionListener(actionListener);
            popupMenu.add(c);
        });
        JButton addDropDownButton = DropDownButtonFactory.createDropDownButton(Icons.ADD, popupMenu);
        addDropDownButton.setPreferredSize(new Dimension(40, addDropDownButton.getPreferredSize().height));
        addDropDownButton.setToolTipText("Create New Notification");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)new JLabel("Notifications"), "West");
        buttonPanel.add((Component)addDropDownButton, "East");
        buttonPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.add((Component)buttonPanel, "North");
        ScrollablePanel scrollablePanel = new ScrollablePanel(new StretchedStackedLayout(3, 3));
        scrollablePanel.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        scrollablePanel.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.STRETCH);
        scrollablePanel.setScrollableBlockIncrement(1, ScrollablePanel.IncrementType.PERCENT, 10);
        scrollablePanel.add((Component)this.notificationContainer);
        JScrollPane scrollPane = new JScrollPane(scrollablePanel, 20, 30);
        this.add((Component)scrollPane, "Center");
    }

    @Inject
    public void rebuild() {
        this.notificationContainer.removeAll();
        for (Notification notification : this.alert.getNotifications()) {
            this.addPanel(notification);
        }
        this.notificationContainer.revalidate();
        this.notificationContainer.repaint();
    }

    private void addPanel(Notification notification) {
        PanelUtils.OnRemove removeNotification = removedPanel -> {
            this.alert.getNotifications().remove(notification);
            this.notificationContainer.remove((Component)removedPanel);
            this.notificationContainer.revalidate();
            this.alertManager.saveAlerts();
        };
        NotificationPanel notificationPanel = null;
        if (notification instanceof GameMessage) {
            notificationPanel = new MessageNotificationPanel((GameMessage)notification, this, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof TextToSpeech) {
            notificationPanel = new TextToSpeechNotificationPanel((TextToSpeech)notification, this, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof Sound) {
            notificationPanel = new SoundNotificationPanel((Sound)notification, this, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof SoundEffect) {
            notificationPanel = new SoundEffectNotificationPanel((SoundEffect)notification, this, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof TrayNotification) {
            notificationPanel = new MessageNotificationPanel((TrayNotification)notification, this, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof ScreenFlash) {
            notificationPanel = new ScreenFlashNotificationPanel((ScreenFlash)notification, this, this.colorPickerManager, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof Overhead) {
            notificationPanel = new OverheadNotificationPanel((Overhead)notification, this, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof Overlay) {
            notificationPanel = new OverlayNotificationPanel((Overlay)notification, this, this.colorPickerManager, this.alertManager::saveAlerts, removeNotification);
        } else if (notification instanceof NotificationEvent) {
            notificationPanel = new MessageNotificationPanel((NotificationEvent)notification, this, this.alertManager::saveAlerts, removeNotification);
        }
        if (notificationPanel != null) {
            this.notificationContainer.add((Component)notificationPanel);
        }
    }

    private Notification createNotification(NotificationType notificationType) {
        Injector injector = WatchdogPlugin.getInstance().getInjector();
        Notification notification = (Notification)injector.getInstance(notificationType.getImplClass());
        notification.setAlert(this.alert);
        this.alert.getNotifications().add(notification);
        return notification;
    }

    public DragAndDropReorderPane getNotificationContainer() {
        return this.notificationContainer;
    }
}

