/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui.panels;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.notifications.IMessageNotification;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.SearchBar;
import com.adamk33n3r.runelite.watchdog.ui.StretchedStackedLayout;
import com.adamk33n3r.runelite.watchdog.ui.panels.HistoryEntryPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import com.adamk33n3r.runelite.watchdog.ui.panels.ScrollablePanel;
import com.google.common.base.Splitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.MultiplexingPluginPanel;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HistoryPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(HistoryPanel.class);
    private final Provider<MultiplexingPluginPanel> muxer;
    private final ScrollablePanel historyItems;
    private final List<HistoryEntryPanel> previousAlerts = new ArrayList<HistoryEntryPanel>();
    private final JLabel noHistory;
    private static final int MAX_HISTORY_ITEMS = 100;
    private static final Splitter SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();

    @Inject
    public HistoryPanel(Provider<MultiplexingPluginPanel> muxer) {
        super(false);
        this.muxer = muxer;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout(0, 5));
        topPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        JButton backButton = PanelUtils.createActionButton(Icons.BACK, Icons.BACK_HOVER, "Back", (btn, modifiers) -> ((MultiplexingPluginPanel)this.muxer.get()).popState());
        backButton.setPreferredSize(new Dimension(22, 16));
        backButton.setBorder(new EmptyBorder(0, 0, 0, 5));
        topPanel.add((Component)backButton, "West");
        topPanel.add((Component)((Object)new SearchBar(this::updateFilter)));
        this.noHistory = new JLabel("No history items");
        this.noHistory.setHorizontalAlignment(0);
        topPanel.add((Component)this.noHistory, "South");
        this.add(topPanel, "North");
        this.historyItems = new ScrollablePanel(new StretchedStackedLayout(3, 3));
        this.historyItems.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.historyItems.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        this.historyItems.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.STRETCH);
        this.historyItems.setScrollableBlockIncrement(1, ScrollablePanel.IncrementType.PERCENT, 10);
        JScrollPane scroll = new JScrollPane(this.historyItems, 20, 31);
        this.add(scroll, "Center");
    }

    public void addEntry(Alert alert, String[] triggerValues) {
        this.noHistory.setVisible(false);
        HistoryEntryPanel historyEntryPanel = new HistoryEntryPanel(alert, triggerValues);
        this.previousAlerts.add(0, historyEntryPanel);
        this.historyItems.add((Component)historyEntryPanel, 0);
        if (this.historyItems.getComponents().length > 100) {
            this.previousAlerts.remove(this.previousAlerts.size() - 1);
            this.historyItems.remove(this.historyItems.getComponents().length - 1);
        }
        this.revalidate();
        this.repaint();
    }

    private void updateFilter(String search) {
        this.historyItems.removeAll();
        this.previousAlerts.stream().filter(historyEntryPanel -> {
            Alert alert = historyEntryPanel.getAlert();
            Stream<String> keywords = Stream.concat(Stream.of(alert.getName(), alert.getType().getName()), alert.getNotifications().stream().flatMap(notification -> {
                Stream<String> notificationType = Stream.of(notification.getType().getName());
                if (notification instanceof IMessageNotification) {
                    return Stream.concat(notificationType, Stream.of(((IMessageNotification)((Object)notification)).getMessage()));
                }
                return notificationType;
            }));
            return Util.searchText(search, keywords.collect(Collectors.toList()));
        }).forEach(this.historyItems::add);
        this.revalidate();
        this.repaint();
    }
}

