/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui.panels;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.Displayable;
import com.adamk33n3r.runelite.watchdog.TriggerType;
import com.adamk33n3r.runelite.watchdog.WatchdogPanel;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.alerts.RegexMatcher;
import com.adamk33n3r.runelite.watchdog.ui.HorizontalRuleBorder;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.ImportExportDialog;
import com.adamk33n3r.runelite.watchdog.ui.PlaceholderTextField;
import com.adamk33n3r.runelite.watchdog.ui.StretchedStackedLayout;
import com.adamk33n3r.runelite.watchdog.ui.ToggleButton;
import com.adamk33n3r.runelite.watchdog.ui.panels.HistoryPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.InputGroup;
import com.adamk33n3r.runelite.watchdog.ui.panels.NotificationsPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.info.JRichTextPane;
import net.runelite.client.ui.MultiplexingPluginPanel;
import net.runelite.client.ui.PluginPanel;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlertPanel<T extends Alert>
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(AlertPanel.class);
    private final JPanel controlContainer;
    private final JPanel centerContainer;
    protected final WatchdogPanel watchdogPanel;
    protected final MultiplexingPluginPanel muxer;
    protected final T alert;
    private final AlertManager alertManager;

    public AlertPanel(WatchdogPanel watchdogPanel, T alert) {
        super(false);
        this.watchdogPanel = watchdogPanel;
        this.muxer = watchdogPanel.getMuxer();
        this.alert = alert;
        this.alertManager = WatchdogPlugin.getInstance().getAlertManager();
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new StretchedStackedLayout(3, 3));
        this.add(northPanel, "North");
        JPanel nameGroup = new JPanel(new BorderLayout());
        nameGroup.setBorder(new EmptyBorder(10, 5, 10, 5));
        TriggerType triggerType = ((Alert)this.alert).getType();
        JLabel nameLabel = new JLabel(triggerType.getName());
        nameLabel.setToolTipText(triggerType.getTooltip());
        nameLabel.setForeground(Color.WHITE);
        nameGroup.add((Component)nameLabel, "Center");
        JPanel rightButtons = new JPanel(new GridLayout(1, 0));
        if (alert instanceof AlertGroup) {
            JButton importAlertBtn = PanelUtils.createActionButton(Icons.IMPORT, Icons.IMPORT_HOVER, "Import alert into this group", (btn, modifiers) -> {
                ImportExportDialog importExportDialog = new ImportExportDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (json, append) -> {
                    boolean result = this.alertManager.importAlerts((String)json, ((AlertGroup)alert).getAlerts(), (boolean)append, true, WatchdogPlugin.getInstance().getConfig().overrideImportsWithDefaults());
                    this.rebuild();
                    return result;
                });
                importExportDialog.setVisible(true);
            });
            rightButtons.add(importAlertBtn);
        } else {
            JButton testAlert = PanelUtils.createActionButton(Icons.TEST, Icons.TEST_HOVER, "Test the whole alert", (btn, modifiers) -> {
                String[] triggerValues = new String[]{"1", "2", "3", "4", "5"};
                ((HistoryPanel)((Object)((Object)WatchdogPlugin.getInstance().getPanel().getHistoryPanelProvider().get()))).addEntry((Alert)alert, triggerValues);
                alert.getNotifications().forEach(notification -> notification.fireForced(triggerValues));
            });
            rightButtons.add(testAlert);
        }
        JButton exportAlertBtn = PanelUtils.createActionButton(Icons.EXPORT, Icons.EXPORT_HOVER, "Export this alert", (btn, modifiers) -> {
            ImportExportDialog importExportDialog = new ImportExportDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (Alert)alert);
            importExportDialog.setVisible(true);
        });
        rightButtons.add(exportAlertBtn);
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setSelected(((Alert)alert).isEnabled());
        toggleButton.addItemListener(i -> {
            alert.setEnabled(toggleButton.isSelected());
            this.alertManager.saveAlerts();
        });
        rightButtons.add(toggleButton);
        nameGroup.add((Component)rightButtons, "East");
        JButton backButton = PanelUtils.createActionButton(Icons.BACK, Icons.BACK_HOVER, "Back", (btn, modifiers) -> {
            this.alertManager.saveAlerts();
            this.muxer.popState();
        });
        backButton.setPreferredSize(new Dimension(22, 16));
        backButton.setBorder(new EmptyBorder(0, 0, 0, 5));
        nameGroup.add((Component)backButton, "West");
        northPanel.add((Component)nameGroup, "North");
        this.controlContainer = new JPanel(new StretchedStackedLayout(3, 3));
        this.controlContainer.setBorder(new EmptyBorder(0, 5, 0, 5));
        northPanel.add((Component)this.controlContainer, "North");
        this.centerContainer = new JPanel(new BorderLayout());
        this.add(this.centerContainer, "Center");
    }

    public AlertPanel<T> addLabel(String label) {
        JLabel labelComp = new JLabel(label);
        this.controlContainer.add(labelComp);
        return this;
    }

    public AlertPanel<T> addRichTextPane(String text) {
        JRichTextPane richTextPane = new JRichTextPane();
        richTextPane.setContentType("text/html");
        richTextPane.setText(text);
        richTextPane.setForeground(Color.WHITE);
        this.controlContainer.add((Component)richTextPane);
        return this;
    }

    public AlertPanel<T> addTextField(String placeholder, String tooltip, String initialValue, final Consumer<String> saveAction) {
        final PlaceholderTextField textField = new PlaceholderTextField(initialValue);
        textField.setPlaceholder(placeholder);
        textField.setToolTipText(tooltip);
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                saveAction.accept(textField.getText());
                AlertPanel.this.alertManager.saveAlerts();
            }
        });
        this.controlContainer.add(textField);
        return this;
    }

    public AlertPanel<T> addTextArea(String placeholder, String tooltip, String initialValue, Consumer<String> saveAction) {
        JTextArea textArea = PanelUtils.createTextArea(placeholder, tooltip, initialValue, val -> {
            saveAction.accept((String)val);
            this.alertManager.saveAlerts();
        });
        this.controlContainer.add(textArea);
        return this;
    }

    public AlertPanel<T> addSpinner(String name, String tooltip, int initialValue, Consumer<Integer> saveAction) {
        return this.addSpinner(name, tooltip, initialValue, saveAction, -99, 99, 1);
    }

    public AlertPanel<T> addSpinner(String name, String tooltip, int initialValue, Consumer<Integer> saveAction, int min, int max, int step) {
        JSpinner spinner = PanelUtils.createSpinner(initialValue, min, max, step, val -> {
            saveAction.accept((Integer)val);
            this.alertManager.saveAlerts();
        });
        this.controlContainer.add(PanelUtils.createLabeledComponent(name, tooltip, spinner));
        return this;
    }

    public <E extends Enum<E>> AlertPanel<T> addSelect(String name, String tooltip, Class<E> enumType, E initialValue, Consumer<E> saveAction) {
        JComboBox<Enum> select = new JComboBox<Enum>((Enum[])enumType.getEnumConstants());
        select.setSelectedItem(initialValue);
        select.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (value instanceof Displayable) {
                list.setToolTipText(((Displayable)((Object)value)).getTooltip());
                return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, ((Displayable)((Object)value)).getName(), index, isSelected, cellHasFocus);
            }
            String titleized = WordUtils.capitalizeFully((String)value.name());
            list.setToolTipText(titleized);
            return new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)list, titleized, index, isSelected, cellHasFocus);
        });
        select.addActionListener(e -> {
            saveAction.accept((Enum)select.getItemAt(select.getSelectedIndex()));
            this.alertManager.saveAlerts();
        });
        this.controlContainer.add(PanelUtils.createLabeledComponent(name, tooltip, select));
        return this;
    }

    public AlertPanel<T> addCheckbox(String name, String tooltip, boolean initialValue, Consumer<Boolean> saveAction) {
        JCheckBox checkbox = PanelUtils.createCheckbox(name, tooltip, initialValue, val -> {
            saveAction.accept((Boolean)val);
            this.alertManager.saveAlerts();
        });
        this.controlContainer.add(checkbox);
        return this;
    }

    public AlertPanel<T> addInputGroupWithSuffix(JComponent mainComponent, JComponent suffix) {
        return this.addInputGroup(mainComponent, null, Collections.singletonList(suffix));
    }

    public AlertPanel<T> addInputGroup(JComponent mainComponent, List<JComponent> prefixes, List<JComponent> suffixes) {
        InputGroup textFieldGroup = new InputGroup(mainComponent).addPrefixes(prefixes).addSuffixes(suffixes);
        this.controlContainer.add(textFieldGroup);
        return this;
    }

    public AlertPanel<T> addAlertDefaults() {
        return this.addTextField("Enter the alert name...", "Name of Alert", ((Alert)this.alert).getName(), arg_0 -> this.alert.setName(arg_0)).addSpinner("Debounce Time (ms)", "How long to wait before allowing this alert to trigger again in milliseconds", ((Alert)this.alert).getDebounceTime(), arg_0 -> this.alert.setDebounceTime(arg_0), 0, 8640000, 100);
    }

    public AlertPanel<T> addIf(Consumer<AlertPanel<T>> panel, Supplier<Boolean> ifFunc) {
        if (ifFunc.get().booleanValue()) {
            panel.accept(this);
        }
        return this;
    }

    public AlertPanel<T> addRegexMatcher(RegexMatcher regexMatcher, String placeholder, String tooltip) {
        return this.addInputGroupWithSuffix(PanelUtils.createTextArea(placeholder, tooltip, regexMatcher.getPattern(), msg -> {
            if (!PanelUtils.isPatternValid((Component)((Object)this), msg, regexMatcher.isRegexEnabled())) {
                return;
            }
            regexMatcher.setPattern((String)msg);
            this.alertManager.saveAlerts();
        }), PanelUtils.createToggleActionButton(Icons.REGEX_SELECTED, Icons.REGEX_SELECTED_HOVER, Icons.REGEX, Icons.REGEX_HOVER, "Disable regex", "Enable regex", regexMatcher.isRegexEnabled(), (btn, modifiers) -> {
            regexMatcher.setRegexEnabled(btn.isSelected());
            this.alertManager.saveAlerts();
        }));
    }

    public AlertPanel<T> addNotifications() {
        NotificationsPanel notificationPanel = new NotificationsPanel((Alert)this.alert);
        WatchdogPlugin.getInstance().getInjector().injectMembers((Object)notificationPanel);
        notificationPanel.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 0, 5), new HorizontalRuleBorder(10)));
        this.centerContainer.add(notificationPanel);
        return this;
    }

    public AlertPanel<T> addSubPanel(JPanel sub) {
        this.centerContainer.add(sub);
        return this;
    }

    protected abstract void build();

    protected void rebuild() {
        this.controlContainer.removeAll();
        this.centerContainer.removeAll();
        this.build();
        this.revalidate();
        this.repaint();
    }

    public void onActivate() {
        this.rebuild();
    }
}

