/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui.panels;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.TriggerType;
import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.ui.AlertListItemNew;
import com.adamk33n3r.runelite.watchdog.ui.SearchBar;
import com.adamk33n3r.runelite.watchdog.ui.StretchedStackedLayout;
import com.adamk33n3r.runelite.watchdog.ui.panels.ScrollablePanel;
import com.google.common.base.Splitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.DragAndDropReorderPane;

public class AlertListPanel
extends JPanel {
    private String filterText = "";
    private static final Splitter SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private final List<AlertListItemNew> alertListItems = new ArrayList<AlertListItemNew>();
    private final DragAndDropReorderPane dragAndDropReorderPane = new DragAndDropReorderPane();
    private final JScrollPane scrollPane;

    public AlertListPanel(List<Alert> alerts, Runnable onChange) {
        AlertManager alertManager = WatchdogPlugin.getInstance().getAlertManager();
        this.dragAndDropReorderPane.setBackground(ColorScheme.GRAND_EXCHANGE_LIMIT);
        this.dragAndDropReorderPane.addDragListener(c -> {
            int pos = this.dragAndDropReorderPane.getPosition(c);
            AlertListItemNew alertListItem = (AlertListItemNew)c;
            alertManager.moveAlertTo(alertListItem.getAlert(), pos);
        });
        this.setLayout(new BorderLayout());
        SearchBar searchBar = new SearchBar(this::filter);
        Arrays.stream(TriggerType.values()).map(TriggerType::getName).forEach(searchBar.getSuggestionListModel()::addElement);
        JPanel searchWrapper = new JPanel(new BorderLayout());
        searchWrapper.add((Component)((Object)searchBar));
        searchWrapper.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.add((Component)searchWrapper, "North");
        ScrollablePanel scrollablePanel = new ScrollablePanel(new StretchedStackedLayout(3, 3));
        scrollablePanel.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        scrollablePanel.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.STRETCH);
        scrollablePanel.setScrollableBlockIncrement(1, ScrollablePanel.IncrementType.PERCENT, 10);
        scrollablePanel.add((Component)this.dragAndDropReorderPane);
        this.scrollPane = new JScrollPane(scrollablePanel, 20, 30);
        this.add((Component)this.scrollPane, "Center");
        alerts.stream().map(alert -> new AlertListItemNew(WatchdogPlugin.getInstance().getPanel(), alertManager, (Alert)alert, (JComponent)this.dragAndDropReorderPane, onChange)).forEach(alertListItem -> {
            this.alertListItems.add((AlertListItemNew)alertListItem);
            this.dragAndDropReorderPane.add((Component)alertListItem);
        });
    }

    private void filter(String text) {
        this.filterText = text;
        this.dragAndDropReorderPane.removeAll();
        this.alertListItems.stream().filter((? super T alertListItem) -> Util.searchText(this.filterText, alertListItem.getAlert().getKeywords())).forEach(arg_0 -> this.dragAndDropReorderPane.add(arg_0));
        this.revalidate();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }
}

