/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class PlaceholderTextField
extends JTextField {
    private String placeholder;
    private static final Map<?, ?> hints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");

    public PlaceholderTextField() {
    }

    public PlaceholderTextField(Document pDoc, String pText, int pColumns) {
        super(pDoc, pText, pColumns);
    }

    public PlaceholderTextField(String pText) {
        super(pText);
    }

    @Override
    protected void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getDisabledTextColor());
        g.drawString(this.placeholder, this.getInsets().left, g.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }
}

