/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui;

import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(ImportExportDialog.class);

    public ImportExportDialog(Component parent, BiFunction<String, Boolean, Boolean> onImport) {
        this.setTitle("Import");
        this.setSize(500, 250);
        this.setLocationRelativeTo(parent);
        this.setModal(true);
        this.setUndecorated(true);
        JPanel wrapper = this.createWrapper();
        this.add(wrapper);
        wrapper.add((Component)new JLabel("Paste the Alert JSON here"), "North");
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        wrapper.add((Component)scrollPane, "Center");
        JPanel btnGroup = new JPanel(new GridLayout(1, 2, 25, 0));
        Function<Boolean, ActionListener> importAlertFn = append -> ev -> {
            if (!append.booleanValue() && JOptionPane.showConfirmDialog(this, "Are you sure you wish to overwrite your alerts?", "Confirm Overwrite?", 0) == 1) {
                return;
            }
            String json = textArea.getText();
            try {
                if (((Boolean)onImport.apply(json, (Boolean)append)).booleanValue()) {
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                log.error("Error parsing json: " + ex);
                JOptionPane.showMessageDialog(this, "There was an error parsing the alert json", "Error parsing JSON", 0);
            }
        };
        JButton importOverwriteBtn = new JButton("Import (Overwrite)");
        importOverwriteBtn.addActionListener(importAlertFn.apply(false));
        btnGroup.add(importOverwriteBtn);
        JButton importAppendBtn = new JButton("Import (Append)");
        importAppendBtn.addActionListener(importAlertFn.apply(true));
        btnGroup.add(importAppendBtn);
        JButton closeBtn = new JButton("Cancel");
        closeBtn.addActionListener(ev -> this.setVisible(false));
        btnGroup.add(closeBtn);
        wrapper.add((Component)btnGroup, "South");
    }

    public ImportExportDialog(Component parent, Alert alert) {
        Gson gson = WatchdogPlugin.getInstance().getAlertManager().getGson();
        String json = gson.toJson((Object)alert);
        String pretty = gson.newBuilder().setPrettyPrinting().create().toJson((Object)alert);
        this.show(parent, json, pretty);
    }

    public ImportExportDialog(Component parent, List<Alert> alerts) {
        Gson gson = WatchdogPlugin.getInstance().getAlertManager().getGson();
        String json = gson.toJson(alerts);
        String pretty = gson.newBuilder().setPrettyPrinting().create().toJson(alerts);
        this.show(parent, json, pretty);
    }

    public void show(Component parent, String exportString, String prettyExportString) {
        this.setTitle("Export");
        this.setSize(500, 250);
        this.setLocationRelativeTo(parent);
        this.setModal(true);
        this.setUndecorated(true);
        JTextArea textArea = new JTextArea(exportString);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        SwingUtilities.invokeLater(textArea::requestFocusInWindow);
        JPanel wrapper = this.createWrapper();
        this.add(wrapper);
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)new JLabel("Exported Alert JSON"), "West");
        JCheckBox prettyPrint = PanelUtils.createCheckbox("Pretty Print", "Pretty Print", false, selected -> {
            textArea.setText(selected != false ? prettyExportString : exportString);
            textArea.setCaretPosition(0);
            textArea.requestFocusInWindow();
        });
        top.add((Component)prettyPrint, "East");
        wrapper.add((Component)top, "North");
        JPanel btnGroup = new JPanel(new GridLayout(1, 2, 25, 0));
        JButton copyBtn = new JButton("Copy to Clipboard");
        copyBtn.addActionListener(ev -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(prettyPrint.isSelected() ? prettyExportString : exportString), null);
            this.setVisible(false);
        });
        btnGroup.add(copyBtn);
        JButton closeBtn = new JButton("Close");
        btnGroup.add(closeBtn);
        closeBtn.addActionListener(ev -> this.setVisible(false));
        wrapper.add((Component)btnGroup, "South");
        JScrollPane scrollPane = new JScrollPane(textArea);
        wrapper.add((Component)scrollPane, "Center");
    }

    private JPanel createWrapper() {
        JPanel wrapper = new JPanel(new BorderLayout(5, 5));
        wrapper.setBorder(new EmptyBorder(10, 10, 10, 10));
        return wrapper;
    }
}

