/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class HorizontalRuleBorder
extends EtchedBorder {
    private final int size;
    private final Border outsideBorder;

    public HorizontalRuleBorder(int size) {
        this.size = size;
        this.outsideBorder = new EmptyBorder(this.size, 0, 0, 0);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets outerInsets = this.outsideBorder.getBorderInsets(c);
        insets.set(this.size + outerInsets.top, 0, 0, 0);
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int px = x;
        int py = y;
        int pw = width;
        int ph = height;
        this.outsideBorder.paintBorder(c, g, px, py, pw, ph);
        Insets nextInsets = this.outsideBorder.getBorderInsets(c);
        pw = pw - nextInsets.right - nextInsets.left;
        ph = ph - nextInsets.bottom - nextInsets.top;
        g.translate(px += nextInsets.left, py += nextInsets.top);
        g.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
        g.drawLine(0, 0, pw - 2, 0);
        g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
        g.drawLine(1, 1, pw - 3, 1);
        g.translate(-px, -py);
    }
}

