/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui;

import com.adamk33n3r.runelite.watchdog.ui.PlaceholderTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import net.runelite.client.ui.ColorScheme;

public class FlatTextArea
extends JPanel {
    private final PlaceholderTextArea textArea;
    private Color backgroundColor = ColorScheme.DARKER_GRAY_COLOR;
    private Color hoverBackgroundColor;
    private boolean blocked;

    public FlatTextArea(String placeholder) {
        this.setLayout(new BorderLayout());
        this.setBackground(this.backgroundColor);
        this.textArea = new PlaceholderTextArea();
        this.textArea.setPlaceholder(placeholder);
        this.textArea.setOpaque(false);
        this.textArea.setSelectedTextColor(Color.WHITE);
        this.textArea.setSelectionColor(ColorScheme.BRAND_ORANGE_TRANSPARENT);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setMargin(new Insets(4, 6, 5, 6));
        this.add((Component)this.textArea, "Center");
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (FlatTextArea.this.blocked) {
                    return;
                }
                if (FlatTextArea.this.hoverBackgroundColor != null) {
                    FlatTextArea.this.setBackground(FlatTextArea.this.hoverBackgroundColor, false);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FlatTextArea.this.setBackground(FlatTextArea.this.backgroundColor);
            }
        });
    }

    public FlatTextArea(String placeholder, boolean preventNewline) {
        this(placeholder);
        if (!preventNewline) {
            return;
        }
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = this.textArea.getInputMap(0);
        ActionMap actionMap = this.textArea.getActionMap();
        inputMap.put(enterKey, enterKey.toString());
        actionMap.put(enterKey.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea textArea = (JTextArea)e.getSource();
                textArea.getParent().getParent().requestFocusInWindow();
            }
        });
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.textArea.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.textArea.removeKeyListener(keyListener);
    }

    @Override
    public void setBackground(Color color) {
        this.setBackground(color, true);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textArea.requestFocusInWindow();
    }

    public void setBackground(Color color, boolean saveColor) {
        if (color == null) {
            return;
        }
        super.setBackground(color);
        if (saveColor) {
            this.backgroundColor = color;
        }
    }

    public void setHoverBackgroundColor(Color color) {
        if (color == null) {
            return;
        }
        this.hoverBackgroundColor = color;
    }

    public void setEditable(boolean editable) {
        this.blocked = !editable;
        this.textArea.setEditable(editable);
        this.textArea.setFocusable(editable);
        if (!editable) {
            super.setBackground(this.backgroundColor);
        }
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    public PlaceholderTextArea getTextArea() {
        return this.textArea;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    public boolean isBlocked() {
        return this.blocked;
    }
}

