/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.ui;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.WatchdogPanel;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.StretchedStackedLayout;
import com.adamk33n3r.runelite.watchdog.ui.ToggleButton;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.config.ConfigPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.MouseDragEventForwarder;
import net.runelite.client.util.ImageUtil;

public class AlertListItemNew
extends JPanel {
    private static final ImageIcon SECTION_EXPAND_ICON;
    private static final ImageIcon SECTION_EXPAND_ICON_HOVER;
    private static final ImageIcon SECTION_RETRACT_ICON;
    private static final ImageIcon SECTION_RETRACT_ICON_HOVER;
    private static final int ROW_HEIGHT = 30;
    private static final int PADDING = 2;
    private final MouseDragEventForwarder mouseDragEventForwarder;
    private final AlertManager alertManager;
    private final WatchdogPanel panel;
    private boolean collapsed = true;
    private final Alert alert;
    private final Runnable onChange;

    public AlertListItemNew(WatchdogPanel panel, AlertManager alertManager, Alert alert, JComponent parent, Runnable onChange) {
        this.panel = panel;
        this.alert = alert;
        this.alertManager = alertManager;
        this.onChange = onChange;
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.mouseDragEventForwarder = new MouseDragEventForwarder((Component)parent);
        this.rebuild();
    }

    public void rebuild() {
        this.removeAll();
        JPanel container = new JPanel(new StretchedStackedLayout(3, 3));
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel topWrapper = new JPanel(new BorderLayout(3, 3));
        container.add(topWrapper);
        topWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        topWrapper.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, this.collapsed ? 0 : 2, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createMatteBorder(5, 10, 5, 0, ColorScheme.DARKER_GRAY_COLOR)));
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setSelected(this.alert.isEnabled());
        toggleButton.addItemListener(i -> {
            this.alert.setEnabled(toggleButton.isSelected());
            this.alertManager.saveAlerts();
        });
        topWrapper.add((Component)toggleButton, "West");
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        topWrapper.add((Component)nameWrapper, "Center");
        if (this.alert instanceof AlertGroup) {
            JButton collapseButton = PanelUtils.createActionButton(this.collapsed ? SECTION_EXPAND_ICON : SECTION_RETRACT_ICON, this.collapsed ? SECTION_EXPAND_ICON_HOVER : SECTION_RETRACT_ICON_HOVER, this.collapsed ? "Expand" : "Collapse", (btn, evt) -> {
                this.collapsed = !this.collapsed;
                this.rebuild();
                this.revalidate();
            });
            nameWrapper.add((Component)collapseButton, "West");
        }
        JLabel nameLabel = new JLabel(this.alert.getName());
        nameLabel.setToolTipText(this.alert.getName());
        nameWrapper.add(nameLabel);
        topWrapper.addMouseListener((MouseListener)this.mouseDragEventForwarder);
        topWrapper.addMouseMotionListener((MouseMotionListener)this.mouseDragEventForwarder);
        nameWrapper.addMouseListener((MouseListener)this.mouseDragEventForwarder);
        nameWrapper.addMouseMotionListener((MouseMotionListener)this.mouseDragEventForwarder);
        nameLabel.addMouseListener((MouseListener)this.mouseDragEventForwarder);
        if (this.alert instanceof AlertGroup) {
            nameLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        AlertListItemNew.this.collapsed = !AlertListItemNew.this.collapsed;
                        AlertListItemNew.this.rebuild();
                        AlertListItemNew.this.revalidate();
                    }
                }
            });
        }
        nameLabel.addMouseMotionListener((MouseMotionListener)this.mouseDragEventForwarder);
        JPanel rightActions = new JPanel(new FlowLayout(2, 3, 0));
        rightActions.setBorder(new EmptyBorder(4, 0, 0, 0));
        rightActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        topWrapper.add((Component)rightActions, "East");
        rightActions.add(PanelUtils.createActionButton(Icons.EDIT, Icons.EDIT, "Edit Alert", (btn, modifiers) -> this.panel.openAlert(this.alert)));
        rightActions.add(PanelUtils.createActionButton(Icons.CLONE, Icons.CLONE, "Clone Alert", (btn, modifiers) -> {
            Alert cloned = this.alertManager.cloneAlert(this.alert);
            AlertGroup parent = this.alert.getParent();
            if (parent != null) {
                cloned.setParent(parent);
                parent.getAlerts().add(cloned);
            } else {
                this.alertManager.getAlerts().add(cloned);
            }
            this.alertManager.saveAlerts();
            this.onChange.run();
        }));
        JButton deleteButton = PanelUtils.createActionButton(Icons.DELETE, Icons.DELETE, "Delete Alert", (btn, modifiers) -> {
            int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the " + this.alert.getName() + " alert?", "Delete?", 0, 0);
            if (result == 0) {
                this.alertManager.removeAlert(this.alert);
                this.onChange.run();
            }
        });
        rightActions.add(deleteButton);
        if (this.alert instanceof AlertGroup && !this.collapsed) {
            JPanel settings = new JPanel(new StretchedStackedLayout(3, 3));
            settings.setBorder(new EmptyBorder(0, 10, 5, 10));
            settings.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            List<Alert> subAlerts = ((AlertGroup)this.alert).getAlerts();
            for (Alert subAlert : subAlerts) {
                settings.add(new JLabel(subAlert.getName()));
            }
            if (subAlerts.size() == 0) {
                settings.add(new JLabel("No alerts in group"));
            }
            container.add(settings);
        }
        this.add((Component)container, "Center");
    }

    public Alert getAlert() {
        return this.alert;
    }

    static {
        BufferedImage sectionRetractIcon = ImageUtil.loadImageResource(ConfigPlugin.class, (String)"/util/arrow_right.png");
        sectionRetractIcon = ImageUtil.luminanceOffset((Image)sectionRetractIcon, (int)-121);
        SECTION_EXPAND_ICON = new ImageIcon(sectionRetractIcon);
        SECTION_EXPAND_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)sectionRetractIcon, (int)-100));
        BufferedImage sectionExpandIcon = ImageUtil.rotateImage((BufferedImage)sectionRetractIcon, (double)1.5707963267948966);
        SECTION_RETRACT_ICON = new ImageIcon(sectionExpandIcon);
        SECTION_RETRACT_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)sectionExpandIcon, (int)-100));
    }
}

