/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.notifications;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.notifications.AudioNotification;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;

public class SoundEffect
extends AudioNotification {
    private int soundID;
    @Inject
    private transient Client client;
    @Inject
    private transient ClientThread clientThread;

    public SoundEffect() {
        this.gain = 8;
    }

    @Inject
    public SoundEffect(WatchdogConfig config) {
        super(config);
        this.gain = config.defaultSoundEffectVolume();
        this.soundID = config.defaultSoundEffectID();
    }

    @Override
    protected void fireImpl(String[] triggerValues) {
        this.clientThread.invokeLater(() -> this.client.playSoundEffect(this.soundID, Util.scale(this.gain, 0.0f, 10.0f, 0.0f, 127.0f)));
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setSoundID(this.watchdogConfig.defaultSoundEffectID());
        this.setGain(this.watchdogConfig.defaultSoundEffectVolume());
    }

    public int getSoundID() {
        return this.soundID;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public void setSoundID(int soundID) {
        this.soundID = soundID;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setClientThread(ClientThread clientThread) {
        this.clientThread = clientThread;
    }
}

