/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.notifications;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.notifications.AudioNotification;
import java.io.File;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sound
extends AudioNotification {
    private static final Logger log = LoggerFactory.getLogger(Sound.class);
    private String path;

    @Inject
    public Sound(WatchdogConfig config) {
        super(config);
        this.gain = config.defaultSoundVolume();
        this.path = config.defaultSoundPath();
    }

    @Override
    protected void fireImpl(String[] triggerValues) {
        String processedPath = Util.processTriggerValues(this.path, triggerValues);
        WatchdogPlugin.getInstance().getSoundPlayer().play(new File(processedPath), this.gain);
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setGain(this.watchdogConfig.defaultSoundVolume());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Sound() {
    }
}

