/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.notifications;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.notifications.MessageNotification;
import java.awt.Color;
import javax.inject.Inject;

public class Overlay
extends MessageNotification {
    private Color color = WatchdogConfig.DEFAULT_NOTIFICATION_COLOR;
    private Color textColor = WatchdogConfig.DEFAULT_NOTIFICATION_TEXT_COLOR;
    private boolean sticky = false;
    private int timeToLive = 5;
    private String imagePath;

    @Inject
    public Overlay(WatchdogConfig config) {
        super(config);
        this.color = config.defaultOverlayColor();
        this.textColor = config.defaultOverlayTextColor();
        this.sticky = config.defaultOverlaySticky();
        this.timeToLive = config.defaultOverlayTTL();
        this.imagePath = config.defaultOverlayImagePath();
    }

    @Override
    protected void fireImpl(String[] triggerValues) {
        WatchdogPlugin.getInstance().getNotificationOverlay().add(this, Util.processTriggerValues(this.message, triggerValues));
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setColor(this.watchdogConfig.defaultOverlayColor());
        this.setTextColor(this.watchdogConfig.defaultOverlayTextColor());
        this.setSticky(this.watchdogConfig.defaultOverlaySticky());
        this.setTimeToLive(this.watchdogConfig.defaultOverlayTTL());
        this.setImagePath(this.watchdogConfig.defaultOverlayImagePath());
    }

    public Color getColor() {
        return this.color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public Overlay() {
    }
}

