/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.notifications;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.notifications.MessageNotification;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overhead
extends MessageNotification {
    private static final Logger log = LoggerFactory.getLogger(Overhead.class);
    private int displayTime = 3;
    @Inject
    private transient Client client;
    @Inject
    private transient ScheduledExecutorService executor;

    @Inject
    public Overhead(WatchdogConfig config) {
        super(config);
        this.displayTime = config.defaultOverHeadDisplayTime();
    }

    @Override
    protected void fireImpl(String[] triggerValues) {
        String message = Util.processTriggerValues(this.message, triggerValues);
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        localPlayer.setOverheadText(message);
        this.executor.schedule(() -> {
            if (localPlayer.getOverheadText().equals(message)) {
                localPlayer.setOverheadText("");
            }
        }, (long)this.displayTime, TimeUnit.SECONDS);
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setDisplayTime(this.watchdogConfig.defaultOverHeadDisplayTime());
    }

    public Overhead() {
    }

    public int getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(int displayTime) {
        this.displayTime = displayTime;
    }
}

