/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.notifications;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.NotificationType;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.notifications.INotification;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.ClientUI;

public abstract class Notification
implements INotification {
    @Inject
    protected transient ClientUI clientUI;
    @Inject
    protected transient Client client;
    @Inject
    protected transient AlertManager alertManager;
    @Inject
    protected transient WatchdogConfig watchdogConfig;
    private boolean fireWhenFocused = true;
    private boolean fireWhenAFK = false;
    private int fireWhenAFKForSeconds = 1;
    private transient Alert alert;

    @Override
    public Alert getAlert() {
        if (this.alert == null) {
            this.alert = this.alertManager.getAllAlerts().filter(a -> a.getNotifications().contains(this)).findFirst().orElse(null);
        }
        return this.alert;
    }

    @Inject
    public Notification(WatchdogConfig config) {
        this.fireWhenAFK = config.defaultAFKMode();
        this.fireWhenAFKForSeconds = config.defaultAFKSeconds();
    }

    protected boolean shouldFire() {
        int afkTime = (int)Math.floor((float)(Math.min(this.client.getKeyboardIdleTicks(), this.client.getMouseIdleTicks()) * 20) / 1000.0f);
        if (this.fireWhenAFK && afkTime < this.fireWhenAFKForSeconds) {
            return false;
        }
        return !this.clientUI.isFocused() || this.fireWhenFocused;
    }

    @Override
    public void fire(String[] triggerValues) {
        if (this.shouldFire()) {
            new Thread(() -> this.fireImpl(triggerValues)).start();
        }
    }

    public void fireForced(String[] triggerValues) {
        this.fireImpl(triggerValues);
    }

    protected abstract void fireImpl(String[] var1);

    public NotificationType getType() {
        return Arrays.stream(NotificationType.values()).filter(nType -> nType.getImplClass() == this.getClass()).findFirst().orElse(null);
    }

    @Override
    public void setDefaults() {
        this.setFireWhenAFK(this.watchdogConfig.defaultAFKMode());
        this.setFireWhenAFKForSeconds(this.watchdogConfig.defaultAFKSeconds());
    }

    public Notification() {
    }

    public boolean isFireWhenFocused() {
        return this.fireWhenFocused;
    }

    public void setFireWhenFocused(boolean fireWhenFocused) {
        this.fireWhenFocused = fireWhenFocused;
    }

    public boolean isFireWhenAFK() {
        return this.fireWhenAFK;
    }

    public void setFireWhenAFK(boolean fireWhenAFK) {
        this.fireWhenAFK = fireWhenAFK;
    }

    public int getFireWhenAFKForSeconds() {
        return this.fireWhenAFKForSeconds;
    }

    public void setFireWhenAFKForSeconds(int fireWhenAFKForSeconds) {
        this.fireWhenAFKForSeconds = fireWhenAFKForSeconds;
    }

    @Override
    public void setAlert(Alert alert) {
        this.alert = alert;
    }
}

