/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.hub;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.hub.AlertHubCategory;
import com.adamk33n3r.runelite.watchdog.hub.AlertHubClient;
import com.adamk33n3r.runelite.watchdog.hub.AlertHubItem;
import com.adamk33n3r.runelite.watchdog.hub.AlertManifest;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.SearchBar;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import com.adamk33n3r.runelite.watchdog.ui.panels.ScrollablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.MultiplexingPluginPanel;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertHubPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(AlertHubPanel.class);
    private final Provider<MultiplexingPluginPanel> muxer;
    private final AlertHubClient alertHubClient;
    private final ScheduledExecutorService executor;
    private final WatchdogConfig watchdogConfig;
    private List<AlertHubItem> alertHubItems = new ArrayList<AlertHubItem>();
    private final IconTextField searchBar;
    private final JPanel container;
    private final JLabel loading;
    private final JScrollPane scrollPane;

    @Inject
    public AlertHubPanel(Provider<MultiplexingPluginPanel> muxer, AlertHubClient alertHubClient, ScheduledExecutorService executor, WatchdogConfig watchdogConfig) {
        super(false);
        this.muxer = muxer;
        this.alertHubClient = alertHubClient;
        this.executor = executor;
        this.watchdogConfig = watchdogConfig;
        JButton backButton = PanelUtils.createActionButton(Icons.BACK, Icons.BACK_HOVER, "Back", (btn, modifiers) -> ((MultiplexingPluginPanel)this.muxer.get()).popState());
        backButton.setPreferredSize(new Dimension(22, 16));
        backButton.setBorder(new EmptyBorder(0, 0, 0, 5));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        this.searchBar = new SearchBar(this::updateFilter);
        Arrays.stream(AlertHubCategory.values()).map(AlertHubCategory::getName).forEach(this.searchBar.getSuggestionListModel()::addElement);
        this.container = new JPanel((LayoutManager)new DynamicGridLayout(0, 1, 0, 5));
        ScrollablePanel wrapper = new ScrollablePanel(new BorderLayout());
        wrapper.add((Component)this.container, "North");
        this.loading = new JLabel("Loading...");
        this.loading.setVisible(false);
        this.loading.setHorizontalAlignment(0);
        wrapper.add((Component)this.loading, "Center");
        wrapper.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        wrapper.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.STRETCH);
        wrapper.setScrollableBlockIncrement(1, ScrollablePanel.IncrementType.PERCENT, 10);
        wrapper.setScrollableUnitIncrement(1, ScrollablePanel.IncrementType.PERCENT, 10);
        this.scrollPane = new JScrollPane(wrapper, 20, 31);
        JButton refresh = PanelUtils.createActionButton(Icons.REFRESH, Icons.REFRESH_HOVER, "Refresh", (btn, mod) -> this.reloadList(true));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(backButton, 24, 24, 24).addComponent((Component)this.searchBar, 24, 24, 24).addComponent(refresh, 24, 24, 24)).addGap(5).addComponent(this.scrollPane));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(backButton).addComponent((Component)this.searchBar).addComponent(refresh)).addGroup(layout.createSequentialGroup().addGap(5).addComponent(this.scrollPane).addGap(5)));
        this.reloadList(false);
    }

    public void reloadList(boolean forceDownload) {
        if (this.loading.isVisible()) {
            return;
        }
        this.container.removeAll();
        this.loading.setVisible(true);
        this.executor.submit(() -> {
            try {
                List<AlertHubClient.AlertDisplayInfo> alerts = this.alertHubClient.downloadManifest(forceDownload);
                this.reloadList(alerts);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void reloadList(List<AlertHubClient.AlertDisplayInfo> alerts) {
        SwingUtilities.invokeLater(() -> {
            this.loading.setVisible(false);
            this.alertHubItems = alerts.stream().map(alertDisplayInfo -> new AlertHubItem((AlertHubClient.AlertDisplayInfo)alertDisplayInfo, this.watchdogConfig)).collect(Collectors.toList());
            this.updateFilter(this.searchBar.getText());
        });
    }

    private void updateFilter(String search) {
        this.container.removeAll();
        this.alertHubItems.stream().filter(alertHubItem -> {
            AlertManifest manifest = alertHubItem.getAlertDisplayInfo().getManifest();
            return Util.searchText(search, manifest.getKeywords());
        }).forEach(this.container::add);
        this.container.revalidate();
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }
}

