/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.hub;

import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.hub.AlertHubClient;
import com.adamk33n3r.runelite.watchdog.hub.AlertManifest;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.WrappingLabel;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import net.runelite.client.RuneLite;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class AlertHubItem
extends JPanel {
    private static final int LINE_HEIGHT = 16;
    private final AlertHubClient.AlertDisplayInfo alertDisplayInfo;

    public AlertHubItem(AlertHubClient.AlertDisplayInfo alertDisplayInfo, WatchdogConfig watchdogConfig) {
        this.alertDisplayInfo = alertDisplayInfo;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        AlertManifest manifest = this.alertDisplayInfo.getManifest();
        JLabel alertName = new JLabel(manifest.getDisplayName());
        alertName.setFont(FontManager.getRunescapeBoldFont());
        alertName.setToolTipText(manifest.getDisplayName());
        JLabel alertAuthor = new JLabel(manifest.getAuthor());
        alertAuthor.setFont(FontManager.getRunescapeSmallFont());
        alertAuthor.setToolTipText(manifest.getAuthor());
        alertName.setIcon(new ImageIcon(ImageUtil.loadImageResource(RuneLite.class, (String)manifest.getCategory().getIcon())));
        JLabel compatVersion = new JLabel(manifest.getCompatibleVersion());
        compatVersion.setHorizontalAlignment(4);
        compatVersion.setFont(FontManager.getRunescapeSmallFont());
        compatVersion.setToolTipText("Compatible with Watchdog v" + manifest.getCompatibleVersion());
        WrappingLabel alertDescLabel = new WrappingLabel(manifest.getDescription());
        JButton moreInfoButton = PanelUtils.createActionButton(Icons.HELP, Icons.HELP_HOVER, "More info", (btn, mod) -> LinkBrowser.browse((String)manifest.getRepo().toString()));
        if (manifest.getRepo() == null) {
            moreInfoButton.setVisible(false);
        }
        JButton addButton = new JButton();
        addButton.setText("Add");
        BufferedImage addIcon = ImageUtil.recolorImage((Image)Icons.ADD.getImage(), (Color)Color.WHITE);
        addButton.setIcon(new ImageIcon(addIcon));
        addButton.setHorizontalTextPosition(2);
        addButton.setBackground(new Color(2670120));
        addButton.setBorder(new LineBorder(addButton.getBackground().darker()));
        addButton.setFocusPainted(false);
        addButton.addActionListener(ev -> {
            WatchdogPlugin.getInstance().getAlertManager().addAlert(manifest.getAlert(), watchdogConfig.overrideImportsWithDefaults());
            JOptionPane.showMessageDialog(this, "Added " + manifest.getDisplayName() + " to your alerts", "Successfully Added", 1);
        });
        JLabel dependsOn = new JLabel();
        dependsOn.setFont(FontManager.getRunescapeSmallFont());
        if (manifest.getDependsOn() != null) {
            dependsOn.setText("Depends On: " + String.join((CharSequence)", ", manifest.getDependsOn()));
        }
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(alertName, 16, 16, 16).addComponent(moreInfoButton, 16, 16, 16).addComponent(addButton, 16, 16, 16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(alertAuthor, 16, 16, 16).addComponent(compatVersion, 16, 16, 16)).addComponent(alertDescLabel, 0, -1, 96).addComponent(dependsOn, 0, -1, 16).addGap(5)));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(alertName, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(moreInfoButton, 24, 24, 24).addComponent(addButton, 50, 50, -2)).addGroup(layout.createSequentialGroup().addComponent(alertAuthor, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, 100).addComponent(compatVersion, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(alertDescLabel, 0, -1, Short.MAX_VALUE)).addComponent(dependsOn)).addGap(5)));
    }

    public AlertHubClient.AlertDisplayInfo getAlertDisplayInfo() {
        return this.alertDisplayInfo;
    }
}

