/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.hub;

import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.hub.AlertManifest;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.client.util.ImageUtil;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertHubClient {
    private static final Logger log = LoggerFactory.getLogger(AlertHubClient.class);
    private final OkHttpClient cachingClient;
    private static final HttpUrl GITHUB = Objects.requireNonNull(HttpUrl.parse((String)"https://github.com/adamk33n3r/runelite-watchdog"));

    @Inject
    public AlertHubClient(OkHttpClient cachingClient) {
        this.cachingClient = cachingClient.newBuilder().addInterceptor((Interceptor)new CacheInterceptor(15)).build();
    }

    public List<AlertDisplayInfo> downloadManifest(boolean forceDownload) throws IOException {
        HttpUrl allAlerts = GITHUB.newBuilder().addPathSegment("archive").addPathSegment("alert-hub.zip").build();
        HashMap<String, AlertDisplayInfo> alerts = new HashMap<String, AlertDisplayInfo>();
        Request.Builder reqBuilder = new Request.Builder().url(allAlerts);
        if (forceDownload) {
            reqBuilder.cacheControl(CacheControl.FORCE_NETWORK);
        }
        try (Response res = this.cachingClient.newCall(reqBuilder.build()).execute();){
            ZipEntry entry;
            if (res.code() != 200) {
                throw new IOException("Non-OK response code: " + res.code());
            }
            BufferedInputStream is = new BufferedInputStream(Objects.requireNonNull(res.body()).byteStream());
            ZipInputStream zipInputStream = new ZipInputStream(is);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String filePath = entry.getName().replaceAll("runelite-watchdog-alert-hub/", "");
                String[] splitPath = filePath.split("/", 2);
                if (splitPath.length != 2) continue;
                String alertName = splitPath[0];
                if (!alerts.containsKey(alertName)) {
                    alerts.put(alertName, new AlertDisplayInfo());
                }
                AlertDisplayInfo alertDisplayInfo = (AlertDisplayInfo)alerts.get(alertName);
                String alertFile = splitPath[1];
                if (alertFile.equals("alert.json")) {
                    String json = CharStreams.toString((Readable)new InputStreamReader((InputStream)zipInputStream, Charsets.UTF_8));
                    AlertManifest alertManifest = (AlertManifest)WatchdogPlugin.getInstance().getAlertManager().getGson().fromJson(json, AlertManifest.class);
                    alertManifest.setInternalName(alertName);
                    HttpUrl repoPage = GITHUB.newBuilder().addPathSegment("tree").addPathSegment("alert-hub").addPathSegment(alertName).build();
                    alertManifest.setRepo(repoPage.url());
                    alertDisplayInfo.manifest = alertManifest;
                    continue;
                }
                if (!alertFile.equals("icon.png")) continue;
                BufferedImage icon = ImageIO.read(zipInputStream);
                alertDisplayInfo.icon = ImageUtil.resizeImage((BufferedImage)icon, (int)242, (int)182, (boolean)true);
            }
            List<AlertDisplayInfo> list = alerts.values().stream().sorted(Comparator.comparing(alert -> alert.manifest.getDisplayName())).collect(Collectors.toList());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage downloadIcon(AlertManifest alertManifest) throws IOException {
        if (!alertManifest.isHasIcon()) {
            return null;
        }
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)"https://raw.githubusercontent.com/melkypie/resource-packs")).newBuilder().addPathSegment(alertManifest.getCommit()).addPathSegment("icon.png").build();
        try (Response res = this.cachingClient.newCall(new Request.Builder().url(url).build()).execute();){
            if (res.code() != 200) {
                throw new IOException("Non-OK response code: " + res.code());
            }
            byte[] bytes = Objects.requireNonNull(res.body()).bytes();
            Class<ImageIO> clazz = ImageIO.class;
            synchronized (ImageIO.class) {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return bufferedImage;
            }
        }
    }

    public static class AlertDisplayInfo {
        private AlertManifest manifest;
        private BufferedImage icon;

        public AlertManifest getManifest() {
            return this.manifest;
        }

        public BufferedImage getIcon() {
            return this.icon;
        }
    }

    static class CacheInterceptor
    implements Interceptor {
        private final int minutes;

        public CacheInterceptor(int minutes) {
            this.minutes = minutes;
        }

        @Nonnull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response response = chain.proceed(chain.request());
            CacheControl cacheControl = new CacheControl.Builder().maxAge(this.minutes, TimeUnit.MINUTES).build();
            return response.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", cacheControl.toString()).build();
        }
    }
}

