/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.elevenlabs;

import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.elevenlabs.Voice;
import com.adamk33n3r.runelite.watchdog.elevenlabs.Voices;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElevenLabs {
    private static final Logger log = LoggerFactory.getLogger(ElevenLabs.class);
    private static final String BASE_URL = "https://api.elevenlabs.io/";

    public static void getVoice(OkHttpClient client, String voiceID, Consumer<Voice> callback) {
        Request request = new Request.Builder().url("https://api.elevenlabs.io/v1/voices/" + voiceID).addHeader("accept", "application/json").addHeader("xi-api-key", WatchdogPlugin.getInstance().getConfig().elevenLabsAPIKey()).build();
        ElevenLabs.makeRequest(client, request, Voice.class, callback);
    }

    public static void getVoices(OkHttpClient client, Consumer<Voices> callback) {
        Request request = new Request.Builder().url("https://api.elevenlabs.io/v1/voices").addHeader("accept", "application/json").addHeader("xi-api-key", WatchdogPlugin.getInstance().getConfig().elevenLabsAPIKey()).build();
        ElevenLabs.makeRequest(client, request, Voices.class, callback);
    }

    public static void generateTTS(OkHttpClient client, Voice voice, String message, Consumer<File> callback) {
        Request request = new Request.Builder().url("https://api.elevenlabs.io/v1/text-to-speech/" + voice.getVoiceId()).post(RequestBody.create((MediaType)RuneLiteAPI.JSON, (String)("{\n  \"text\": \"" + message + "\",\n  \"model_id\": \"eleven_monolingual_v1\",\n  \"voice_settings\": {\n    \"stability\": 0.5,\n    \"similarity_boost\": 0.5,\n    \"style\": 0.5,\n    \"use_speaker_boost\": true\n  }\n}"))).addHeader("xi-api-key", WatchdogPlugin.getInstance().getConfig().elevenLabsAPIKey()).build();
        ElevenLabs.makeRequest(client, request, File.class, callback);
    }

    public static void download(OkHttpClient client, String id, Consumer<File> callback) {
        Request request = new Request.Builder().url("https://api.elevenlabs.io/v1/history/download").post(RequestBody.create((MediaType)RuneLiteAPI.JSON, (String)("{\n  \"history_item_ids\": [\n    \"" + id + "\"\n  ]\n}"))).addHeader("xi-api-key", WatchdogPlugin.getInstance().getConfig().elevenLabsAPIKey()).build();
        ElevenLabs.makeRequest(client, request, File.class, callback);
    }

    private static <T> void makeRequest(OkHttpClient client, final Request request, final Class<T> rType, final Consumer<T> callback) {
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@Nonnull Call call, @Nonnull IOException e) {
                System.err.println("Error with request at: " + request.url());
                e.printStackTrace();
            }

            public void onResponse(@Nonnull Call call, @Nonnull Response response) throws IOException {
                block17: {
                    try (ResponseBody responseBody = response.body();){
                        if (!response.isSuccessful()) {
                            log.error("Unexpected error code: " + response);
                            return;
                        }
                        if (responseBody == null) {
                            log.error("Response body is null: " + response);
                            return;
                        }
                        if (Objects.requireNonNull(response.header("content-type")).contains("application/json")) {
                            callback.accept(WatchdogPlugin.getInstance().getAlertManager().getGson().fromJson(responseBody.charStream(), rType));
                            break block17;
                        }
                        if (!rType.isAssignableFrom(File.class)) break block17;
                        log.debug("got audio stream");
                        File tmpFile = File.createTempFile("watchdog", ".mp3");
                        InputStream inputStream = responseBody.byteStream();
                        try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);){
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
                                fileOutputStream.write(buffer, 0, bytesRead);
                            }
                        }
                        log.debug("tmp file: " + tmpFile);
                        callback.accept(rType.cast(tmpFile));
                    }
                }
            }
        });
    }
}

