/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog.alerts;

import com.adamk33n3r.runelite.watchdog.TriggerType;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.notifications.MessageNotification;
import com.adamk33n3r.runelite.watchdog.notifications.Notification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class Alert {
    private boolean enabled = true;
    private String name;
    private int debounceTime;
    @Nullable
    private transient AlertGroup parent;
    private List<Notification> notifications = new ArrayList<Notification>();

    public AlertGroup getParent() {
        if (this.parent == null) {
            this.parent = WatchdogPlugin.getInstance().getAlertManager().getAllAlertGroups().filter(alertGroup -> alertGroup.getAlerts().contains(this)).findFirst().orElse(null);
        }
        return this.parent;
    }

    public Alert(String name) {
        this.name = name;
        this.debounceTime = 0;
    }

    public TriggerType getType() {
        return Arrays.stream(TriggerType.values()).filter(tType -> tType.getImplClass() == this.getClass()).findFirst().orElse(null);
    }

    public void moveNotificationTo(Notification notification, int pos) {
        this.notifications.remove(notification);
        this.notifications.add(pos, notification);
    }

    public void moveNotificationToTop(Notification notification) {
        this.notifications.remove(notification);
        this.notifications.add(0, notification);
    }

    public void moveNotificationToBottom(Notification notification) {
        this.notifications.remove(notification);
        this.notifications.add(notification);
    }

    public void moveNotificationUp(Notification notification) {
        int curIdx = this.notifications.indexOf(notification);
        int newIdx = curIdx - 1;
        if (newIdx < 0) {
            return;
        }
        this.notifications.remove(notification);
        this.notifications.add(newIdx, notification);
    }

    public void moveNotificationDown(Notification notification) {
        int curIdx = this.notifications.indexOf(notification);
        int newIdx = curIdx + 1;
        if (newIdx >= this.notifications.size()) {
            return;
        }
        this.notifications.remove(notification);
        this.notifications.add(newIdx, notification);
    }

    @Nullable
    public List<AlertGroup> getAncestors() {
        if (this.parent == null) {
            return null;
        }
        ArrayList<AlertGroup> ancestors = new ArrayList<AlertGroup>();
        AlertGroup alertGroup = this.parent;
        do {
            ancestors.add(0, alertGroup);
        } while ((alertGroup = alertGroup.getParent()) != null);
        return ancestors;
    }

    public List<String> getKeywords() {
        Stream<String> selfKeywords = Stream.of(this.getName(), this.getType().getName());
        if (this instanceof AlertGroup) {
            return Stream.concat(selfKeywords, ((AlertGroup)this).getAlerts().stream().flatMap(alert -> alert.getKeywords().stream())).collect(Collectors.toList());
        }
        return Stream.concat(selfKeywords, this.getNotifications().stream().flatMap(notification -> {
            if (notification instanceof MessageNotification) {
                return Stream.of(notification.getType().getName(), ((MessageNotification)notification).getMessage());
            }
            return Stream.of(notification.getType().getName());
        })).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public int getDebounceTime() {
        return this.debounceTime;
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDebounceTime(int debounceTime) {
        this.debounceTime = debounceTime;
    }

    public void setParent(@Nullable AlertGroup parent) {
        this.parent = parent;
    }

    protected void setNotifications(List<Notification> notifications) {
        this.notifications = notifications;
    }
}

