/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.google.common.base.MoreObjects;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.Text;

public class WrappedTitleComponent
implements LayoutableRenderableEntity {
    private String text;
    private Color color;
    private Font font;
    private Point preferredLocation;
    private Dimension preferredSize;
    private Rectangle bounds;
    private final int LINE_GAP = 2;
    private final int WIDTH_PADDING = 20;
    private final int HEIGHT_PADDING = 8;
    private final int TEXT_PADDING = 20;

    public Dimension render(Graphics2D graphics) {
        Font font = (Font)MoreObjects.firstNonNull((Object)this.font, (Object)graphics.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int fmHeight = fontMetrics.getHeight();
        int baseX = this.preferredLocation.x;
        int baseY = this.preferredLocation.y + fmHeight;
        int x = baseX;
        int y = baseY;
        int smallWidth = this.preferredSize.width;
        int fullWidth = WrappedTitleComponent.getLineWidth(this.text, fontMetrics);
        TextComponent textComponent = new TextComponent();
        if (smallWidth < fullWidth) {
            String[] splitLines;
            for (String text : splitLines = WrappedTitleComponent.lineBreakText(this.text, smallWidth, fontMetrics)) {
                textComponent.setPosition(new Point(x + (smallWidth - fontMetrics.stringWidth(text) + 20) / 2, y + 2));
                textComponent.setText(text);
                textComponent.setColor(this.color);
                textComponent.setFont(font);
                textComponent.render(graphics);
                y += fmHeight;
            }
            Dimension dimension = new Dimension(this.preferredSize.width + 20, y - baseY + 8);
            this.bounds.setLocation(this.preferredLocation);
            this.bounds.setSize(dimension);
            return dimension;
        }
        if (!this.text.isEmpty()) {
            textComponent.setPosition(new Point(x + (smallWidth - fontMetrics.stringWidth(this.text) + 20) / 2, y + 2));
            textComponent.setText(this.text);
            textComponent.setColor(this.color);
            textComponent.setFont(font);
            textComponent.render(graphics);
        }
        Dimension dimension = new Dimension(this.preferredSize.width + 20, (y += fmHeight) - baseY + 8);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    private static int getLineWidth(String line, FontMetrics metrics) {
        return metrics.stringWidth(Text.removeTags((String)line));
    }

    private static String[] lineBreakText(String text, int maxWidth, FontMetrics metrics) {
        String[] words = text.split(" ");
        if (words.length == 0) {
            return new String[0];
        }
        StringBuilder wrapped = new StringBuilder(words[0]);
        int spaceLeft = maxWidth - metrics.stringWidth(wrapped.toString());
        for (int i = 1; i < words.length; ++i) {
            int spaceWidth;
            String word = words[i];
            int wordLen = metrics.stringWidth(word);
            if (wordLen + (spaceWidth = metrics.stringWidth(" ")) > spaceLeft) {
                wrapped.append("\n").append(word);
                spaceLeft = maxWidth - wordLen;
                continue;
            }
            wrapped.append(" ").append(word);
            spaceLeft -= spaceWidth + wordLen;
        }
        return wrapped.toString().split("\n");
    }

    private static String $default$text() {
        return "";
    }

    private static Color $default$color() {
        return Color.WHITE;
    }

    private static Point $default$preferredLocation() {
        return new Point();
    }

    private static Dimension $default$preferredSize() {
        return new Dimension(129, 0);
    }

    private static Rectangle $default$bounds() {
        return new Rectangle();
    }

    WrappedTitleComponent(String text, Color color, Font font, Point preferredLocation, Dimension preferredSize, Rectangle bounds) {
        this.text = text;
        this.color = color;
        this.font = font;
        this.preferredLocation = preferredLocation;
        this.preferredSize = preferredSize;
        this.bounds = bounds;
    }

    public static WrappedTitleComponentBuilder builder() {
        return new WrappedTitleComponentBuilder();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public static class WrappedTitleComponentBuilder {
        private boolean text$set;
        private String text$value;
        private boolean color$set;
        private Color color$value;
        private Font font;
        private boolean preferredLocation$set;
        private Point preferredLocation$value;
        private boolean preferredSize$set;
        private Dimension preferredSize$value;
        private boolean bounds$set;
        private Rectangle bounds$value;

        WrappedTitleComponentBuilder() {
        }

        public WrappedTitleComponentBuilder text(String text) {
            this.text$value = text;
            this.text$set = true;
            return this;
        }

        public WrappedTitleComponentBuilder color(Color color) {
            this.color$value = color;
            this.color$set = true;
            return this;
        }

        public WrappedTitleComponentBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public WrappedTitleComponentBuilder preferredLocation(Point preferredLocation) {
            this.preferredLocation$value = preferredLocation;
            this.preferredLocation$set = true;
            return this;
        }

        public WrappedTitleComponentBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize$value = preferredSize;
            this.preferredSize$set = true;
            return this;
        }

        public WrappedTitleComponentBuilder bounds(Rectangle bounds) {
            this.bounds$value = bounds;
            this.bounds$set = true;
            return this;
        }

        public WrappedTitleComponent build() {
            String text$value = this.text$value;
            if (!this.text$set) {
                text$value = WrappedTitleComponent.$default$text();
            }
            Color color$value = this.color$value;
            if (!this.color$set) {
                color$value = WrappedTitleComponent.$default$color();
            }
            Point preferredLocation$value = this.preferredLocation$value;
            if (!this.preferredLocation$set) {
                preferredLocation$value = WrappedTitleComponent.$default$preferredLocation();
            }
            Dimension preferredSize$value = this.preferredSize$value;
            if (!this.preferredSize$set) {
                preferredSize$value = WrappedTitleComponent.$default$preferredSize();
            }
            Rectangle bounds$value = this.bounds$value;
            if (!this.bounds$set) {
                bounds$value = WrappedTitleComponent.$default$bounds();
            }
            return new WrappedTitleComponent(text$value, color$value, this.font, preferredLocation$value, preferredSize$value, bounds$value);
        }

        public String toString() {
            return "WrappedTitleComponent.WrappedTitleComponentBuilder(text$value=" + this.text$value + ", color$value=" + this.color$value + ", font=" + this.font + ", preferredLocation$value=" + this.preferredLocation$value + ", preferredSize$value=" + this.preferredSize$value + ", bounds$value=" + this.bounds$value + ")";
        }
    }
}

