/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class WatchdogProperties {
    private static final Properties properties;

    public static Properties getProperties() {
        return properties;
    }

    static {
        InputStream in;
        properties = new Properties();
        try {
            in = WatchdogProperties.class.getResourceAsStream("watchdog.properties");
            try {
                properties.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            in = WatchdogProperties.class.getResourceAsStream("version.properties");
            try {
                properties.load(in);
                String pluginVersion = String.format("%s.%s.%s", properties.getProperty("VERSION_MAJOR"), properties.getProperty("VERSION_MINOR"), properties.getProperty("VERSION_PATCH"));
                properties.put("watchdog.pluginVersion", pluginVersion);
                String phase = properties.getProperty("VERSION_PHASE");
                String build = properties.getProperty("VERSION_BUILD");
                String pluginVersionFull = String.format("%s-%s+%s", pluginVersion, phase, build);
                properties.put("watchdog.pluginVersionFull", pluginVersionFull);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

