/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.EventHandler;
import com.adamk33n3r.runelite.watchdog.FlashOverlay;
import com.adamk33n3r.runelite.watchdog.NotificationOverlay;
import com.adamk33n3r.runelite.watchdog.SoundPlayer;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPanel;
import com.adamk33n3r.runelite.watchdog.WatchdogProperties;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.ChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.NotificationFiredAlert;
import com.adamk33n3r.runelite.watchdog.notifications.Notification;
import com.adamk33n3r.runelite.watchdog.notifications.ScreenFlash;
import com.adamk33n3r.runelite.watchdog.notifications.TrayNotification;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.config.ConfigPlugin;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.MultiplexingPluginPanel;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.util.AsyncBufferedImage;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Watchdog", description="Create custom alerts for different events like messages, stats, or built-in notifications", tags={"alert", "notification", "custom", "advanced", "overlay", "sound", "drop", "afk", "tracker", "reminder", "notify", "notifier", "helper", "timer", "message"})
public class WatchdogPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WatchdogPlugin.class);
    @Inject
    private WatchdogConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AlertManager alertManager;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private EventHandler eventHandler;
    @Inject
    private FlashOverlay flashOverlay;
    @Inject
    private NotificationOverlay notificationOverlay;
    @Inject
    private Provider<ConfigPlugin> configPluginProvider;
    private WatchdogPanel panel;
    @Inject
    private SoundPlayer soundPlayer;
    @Inject
    private OkHttpClient httpClient;
    private NavigationButton navButton;
    private static WatchdogPlugin instance;
    private ScheduledFuture<?> soundPlayerFuture;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public WatchdogPlugin() {
        instance = this;
    }

    public void configure(Binder binder) {
        Properties properties = WatchdogProperties.getProperties();
        Names.bindProperties((Binder)binder, (Properties)properties);
        binder.bind(MultiplexingPluginPanel.class).toProvider(() -> this.alertManager.getWatchdogPanel().getMuxer());
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this.eventHandler);
        this.overlayManager.add((Overlay)this.flashOverlay);
        this.overlayManager.add((Overlay)this.notificationOverlay);
        this.alertManager.loadAlerts();
        List<Alert> alerts = this.alertManager.getAlerts();
        if (alerts.isEmpty()) {
            ChatAlert readyToHarvest = new ChatAlert("Ready to Harvest");
            readyToHarvest.setDebounceTime(500);
            readyToHarvest.setMessage("*is ready to harvest*");
            TrayNotification harvestNotification = (TrayNotification)this.injector.getInstance(TrayNotification.class);
            harvestNotification.setMessage("Time to harvest your crops!");
            readyToHarvest.getNotifications().add(harvestNotification);
            this.alertManager.addAlert(readyToHarvest, false);
            NotificationFiredAlert outOfCombat = new NotificationFiredAlert("Out of Combat");
            outOfCombat.setMessage("You are now out of combat!");
            outOfCombat.getNotifications().add((Notification)this.injector.getInstance(ScreenFlash.class));
            this.alertManager.addAlert(outOfCombat, false);
        }
        this.panel = this.alertManager.getWatchdogPanel();
        AsyncBufferedImage icon = this.itemManager.getImage(6846);
        this.navButton = NavigationButton.builder().tooltip("Watchdog").icon((BufferedImage)icon).priority(1).panel((PluginPanel)this.panel.getMuxer()).build();
        this.clientToolbar.addNavigation(this.navButton);
        icon.onLoaded(() -> {
            this.clientToolbar.removeNavigation(this.navButton);
            this.clientToolbar.addNavigation(this.navButton);
        });
        this.startSoundPlayerTimer();
    }

    private void startSoundPlayerTimer() {
        if (this.soundPlayerFuture != null && !this.soundPlayerFuture.isCancelled()) {
            return;
        }
        if (!this.config.putSoundsIntoQueue()) {
            return;
        }
        this.soundPlayerFuture = this.executor.scheduleAtFixedRate(() -> this.soundPlayer.processQueue(), 0L, 100L, TimeUnit.MILLISECONDS);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.eventHandler);
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.flashOverlay);
        this.overlayManager.remove((Overlay)this.notificationOverlay);
    }

    public void openConfiguration() {
        this.eventBus.post((Object)new OverlayMenuClicked(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, null, null), (Overlay)this.notificationOverlay));
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() != MenuAction.RUNELITE_OVERLAY || event.getOverlay() != this.notificationOverlay) {
            return;
        }
        if (event.getEntry().getOption().equals("Clear All")) {
            this.notificationOverlay.clear();
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("watchdog")) {
            if (configChanged.getKey().equals("enableTTS")) {
                while (this.panel.getMuxer().getComponentCount() > 1) {
                    this.panel.getMuxer().popState();
                }
                this.panel.rebuild();
            } else if (configChanged.getKey().equals("putSoundsIntoQueue")) {
                log.debug("sound queue config changed:" + this.config.putSoundsIntoQueue());
                if (this.config.putSoundsIntoQueue()) {
                    this.startSoundPlayerTimer();
                } else {
                    this.getSoundPlayer().clearQueue();
                    this.soundPlayerFuture.cancel(false);
                }
            }
        }
    }

    @Subscribe
    private void onProfileChanged(ProfileChanged profileChanged) {
        this.alertManager.loadAlerts();
    }

    @Provides
    WatchdogConfig provideConfig(ConfigManager configManager) {
        return (WatchdogConfig)configManager.getConfig(WatchdogConfig.class);
    }

    public WatchdogConfig getConfig() {
        return this.config;
    }

    public AlertManager getAlertManager() {
        return this.alertManager;
    }

    public FlashOverlay getFlashOverlay() {
        return this.flashOverlay;
    }

    public NotificationOverlay getNotificationOverlay() {
        return this.notificationOverlay;
    }

    public WatchdogPanel getPanel() {
        return this.panel;
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public static WatchdogPlugin getInstance() {
        return instance;
    }
}

