/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.alerts.ChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.InventoryAlert;
import com.adamk33n3r.runelite.watchdog.alerts.NotificationFiredAlert;
import com.adamk33n3r.runelite.watchdog.alerts.SpawnedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.StatChangedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.XPDropAlert;
import com.adamk33n3r.runelite.watchdog.hub.AlertHubPanel;
import com.adamk33n3r.runelite.watchdog.ui.Icons;
import com.adamk33n3r.runelite.watchdog.ui.ImportExportDialog;
import com.adamk33n3r.runelite.watchdog.ui.alerts.AlertGroupPanel;
import com.adamk33n3r.runelite.watchdog.ui.alerts.GameMessageAlertPanel;
import com.adamk33n3r.runelite.watchdog.ui.alerts.InventoryAlertPanel;
import com.adamk33n3r.runelite.watchdog.ui.alerts.NotificationFiredAlertPanel;
import com.adamk33n3r.runelite.watchdog.ui.alerts.SpawnedAlertPanel;
import com.adamk33n3r.runelite.watchdog.ui.alerts.StatChangedAlertPanel;
import com.adamk33n3r.runelite.watchdog.ui.alerts.XPDropAlertPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.AlertListPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.HistoryPanel;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.MultiplexingPluginPanel;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.LinkBrowser;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchdogPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(WatchdogPanel.class);
    @Inject
    @Named(value="watchdog.helpURL")
    private String HELP_URL;
    @Inject
    @Named(value="watchdog.discordURL")
    private String DISCORD_URL;
    @Inject
    @Named(value="watchdog.kofiURL")
    private String KOFI_URL;
    @Inject
    @Named(value="watchdog.pluginVersion")
    private String PLUGIN_VERSION;
    @Inject
    @Named(value="watchdog.pluginVersionFull")
    private String PLUGIN_VERSION_FULL;
    @Inject
    @Named(value="VERSION_PHASE")
    private String PLUGIN_VERSION_PHASE;
    private final MultiplexingPluginPanel muxer = new MultiplexingPluginPanel((PluginPanel)this);
    @Inject
    private Provider<HistoryPanel> historyPanelProvider;
    @Inject
    private Provider<AlertHubPanel> alertHubPanelProvider;
    @Inject
    private AlertManager alertManager;
    @Inject
    private WatchdogConfig watchdogConfig;
    @Inject
    private OkHttpClient httpClient;
    private AlertListPanel alertListPanel;

    public WatchdogPanel() {
        super(false);
    }

    public void rebuild() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 3));
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 3));
        JLabel title = new JLabel(WatchdogPlugin.getInstance().getName());
        title.setFont(title.getFont().deriveFont(1));
        title.setHorizontalAlignment(2);
        title.setForeground(Color.WHITE);
        boolean isPreRelease = !this.PLUGIN_VERSION_PHASE.equals("release") && !this.PLUGIN_VERSION_PHASE.isEmpty();
        title.setToolTipText("Watchdog v" + (isPreRelease ? this.PLUGIN_VERSION_FULL : this.PLUGIN_VERSION));
        titlePanel.add(title);
        JLabel version = new JLabel("v" + this.PLUGIN_VERSION);
        title.setToolTipText(version.getText());
        version.setFont(version.getFont().deriveFont(10.0f));
        version.setBorder(new EmptyBorder(5, 0, 0, 0));
        titlePanel.add(version);
        topPanel.add(titlePanel);
        JPanel actionButtons = new JPanel(new FlowLayout(2, 0, 0));
        JButton discordButton = PanelUtils.createActionButton(Icons.DISCORD, Icons.DISCORD_HOVER, "Discord", (btn, modifiers) -> LinkBrowser.browse((String)this.DISCORD_URL));
        actionButtons.add(discordButton);
        JButton kofiButton = PanelUtils.createActionButton(Icons.KOFI, Icons.KOFI_HOVER, "Buy me a coffee :)", (btn, modifiers) -> LinkBrowser.browse((String)this.KOFI_URL));
        kofiButton.setPreferredSize(new Dimension(17, 17));
        actionButtons.add(kofiButton);
        JButton helpButton = PanelUtils.createActionButton(Icons.HELP, Icons.HELP_HOVER, "Wiki", (btn, modifiers) -> LinkBrowser.browse((String)this.HELP_URL));
        actionButtons.add(helpButton);
        JButton configButton = PanelUtils.createActionButton(Icons.CONFIG, Icons.CONFIG_HOVER, "Config", (btn, modifiers) -> WatchdogPlugin.getInstance().openConfiguration());
        actionButtons.add(configButton);
        JButton historyButton = PanelUtils.createActionButton(Icons.HISTORY, Icons.HISTORY_HOVER, "History", (btn, modifiers) -> this.muxer.pushState((PluginPanel)this.historyPanelProvider.get()));
        actionButtons.add(historyButton);
        JButton alertDropDownButton = PanelUtils.createAlertDropDownButton(createdAlert -> {
            this.alertManager.addAlert((Alert)createdAlert, false);
            this.openAlert((Alert)createdAlert);
        });
        JPanel addAlertWrapper = new JPanel(new BorderLayout());
        addAlertWrapper.setBorder(new EmptyBorder(0, 5, 0, 0));
        addAlertWrapper.add(alertDropDownButton);
        actionButtons.add(addAlertWrapper);
        topPanel.add((Component)actionButtons, "East");
        this.add(topPanel, "North");
        this.alertListPanel = new AlertListPanel(this.alertManager.getAlerts(), this::rebuild);
        this.add(this.alertListPanel, "Center");
        JPanel importExportGroup = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton importButton = new JButton("Import", Icons.IMPORT);
        importButton.setHorizontalTextPosition(2);
        importButton.addActionListener(ev -> {
            ImportExportDialog importExportDialog = new ImportExportDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (json, append) -> this.alertManager.importAlerts((String)json, this.alertManager.getAlerts(), (boolean)append, true, this.watchdogConfig.overrideImportsWithDefaults()));
            importExportDialog.setVisible(true);
        });
        importExportGroup.add(importButton);
        JButton exportButton = new JButton("Export", Icons.EXPORT);
        exportButton.setHorizontalTextPosition(2);
        exportButton.addActionListener(ev -> {
            ImportExportDialog importExportDialog = new ImportExportDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), this.alertManager.getAlerts());
            importExportDialog.setVisible(true);
        });
        importExportGroup.add(exportButton);
        JPanel bottomPanel = new JPanel(new GridLayout(0, 1, 3, 3));
        bottomPanel.add(importExportGroup);
        JButton hubButton = new JButton("Alert Hub", Icons.DOWNLOAD);
        hubButton.setHorizontalTextPosition(2);
        hubButton.addActionListener(ev -> {
            AlertHubPanel alertHubPanel = (AlertHubPanel)((Object)((Object)this.alertHubPanelProvider.get()));
            this.muxer.pushState((PluginPanel)alertHubPanel);
        });
        bottomPanel.add(hubButton);
        this.add(bottomPanel, "South");
        this.revalidate();
    }

    public void openAlert(Alert alert) {
        PluginPanel panel = this.createPluginPanel(alert);
        if (panel != null) {
            this.muxer.pushState(panel);
        } else {
            log.error(String.format("Tried to open an alert of type %s that doesn't have a panel.", alert.getClass()));
        }
    }

    private PluginPanel createPluginPanel(Alert alert) {
        if (alert instanceof ChatAlert) {
            return new GameMessageAlertPanel(this, (ChatAlert)alert);
        }
        if (alert instanceof NotificationFiredAlert) {
            return new NotificationFiredAlertPanel(this, (NotificationFiredAlert)alert);
        }
        if (alert instanceof StatChangedAlert) {
            return new StatChangedAlertPanel(this, (StatChangedAlert)alert);
        }
        if (alert instanceof XPDropAlert) {
            return new XPDropAlertPanel(this, (XPDropAlert)alert);
        }
        if (alert instanceof SpawnedAlert) {
            return new SpawnedAlertPanel(this, (SpawnedAlert)alert);
        }
        if (alert instanceof InventoryAlert) {
            return new InventoryAlertPanel(this, (InventoryAlert)alert);
        }
        if (alert instanceof AlertGroup) {
            return new AlertGroupPanel(this, (AlertGroup)alert);
        }
        return null;
    }

    public void onActivate() {
        this.rebuild();
    }

    public void scrollToBottom() {
        JScrollBar scrollBar = this.alertListPanel.getScrollPane().getVerticalScrollBar();
        scrollBar.setValue(scrollBar.getMaximum());
    }

    public MultiplexingPluginPanel getMuxer() {
        return this.muxer;
    }

    public Provider<HistoryPanel> getHistoryPanelProvider() {
        return this.historyPanelProvider;
    }
}

