/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.alerts.FlashMode;
import com.adamk33n3r.runelite.watchdog.notifications.tts.TTSSource;
import com.adamk33n3r.runelite.watchdog.notifications.tts.Voice;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.FlashNotification;
import net.runelite.client.config.FontType;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.util.ColorUtil;

@ConfigGroup(value="watchdog")
public interface WatchdogConfig
extends Config {
    public static final String CONFIG_GROUP_NAME = "watchdog";
    public static final Color DEFAULT_NOTIFICATION_COLOR = ColorUtil.fromHex((String)"#46FF0000");
    public static final Color DEFAULT_NOTIFICATION_TEXT_COLOR = Color.WHITE;
    public static final String ALERTS = "alerts";
    public static final String PLUGIN_VERSION = "pluginVersion";
    public static final String ENABLE_TTS = "enableTTS";
    public static final String OVERRIDE_IMPORTS_WITH_DEFAULTS = "overrideImportsWithDefaults";
    public static final String DEFAULT_AFK_MODE = "defaultAFKMode";
    public static final String DEFAULT_AFK_SECONDS = "defaultAFKSeconds";
    public static final String DEFAULT_OVERHEAD_DISPLAY_TIME = "defaultOverheadDisplayTime";
    public static final String OVERLAY_LAYER = "overlayLayer";
    public static final String OVERLAY_FONT_TYPE = "overlayFontType";
    public static final String OVERLAY_SHOW_TIME = "overlayShowTime";
    public static final String DEFAULT_OVERLAY_STICKY = "defaultOverlaySticky";
    public static final String DEFAULT_OVERLAY_TEXT_COLOR = "defaultOverlayTextColor";
    public static final String DEFAULT_OVERLAY_COLOR = "defaultOverlayColor";
    public static final String DEFAULT_OVERLAY_TTL = "defaultOverlayTTL";
    public static final String DEFAULT_OVERLAY_IMAGE_PATH = "defaultOverlayImagePath";
    public static final String MOUSE_MOVEMENT_CANCELS_FLASH = "mouseMovementCancelsFlash";
    public static final String DEFAULT_SCREEN_FLASH_COLOR = "defaultScreenFlashColor";
    public static final String DEFAULT_SCREEN_FLASH_TYPE = "defaultScreenFlashType";
    public static final String DEFAULT_SCREEN_FLASH_MODE = "defaultScreenFlashMode";
    public static final String DEFAULT_SCREEN_FLASH_DURATION = "defaultScreenFlashDuration";
    public static final String PUT_SOUNDS_INTO_QUEUE = "putSoundsIntoQueue";
    public static final String DEFAULT_SOUND_VOLUME = "defaultSoundVolume";
    public static final String DEFAULT_SOUND_PATH = "defaultSoundPath";
    public static final String DEFAULT_SOUND_EFFECT_ID = "defaultSoundEffectID";
    public static final String DEFAULT_SOUND_EFFECT_VOLUME = "defaultSoundEffectVolume";
    public static final String DEFAULT_TTS_VOLUME = "defaultTTSVolume";
    public static final String DEFAULT_TTS_SOURCE = "defaultTTSSource";
    public static final String DEFAULT_TTS_VOICE = "defaultTTSVoice";
    public static final String DEFAULT_TTS_RATE = "defaultTTSRate";
    public static final String ELEVEN_LABS_API_KEY = "elevenLabsAPIKey";
    public static final String DEFAULT_ELEVEN_LABS_VOICE = "defaultElevenLabsVoice";
    @ConfigSection(name="AFK Notification", description="The options that control the afk notification settings", position=0)
    public static final String afkNotificationSection = "afkNotificationSection";
    @ConfigSection(name="Overhead", description="The options that control the overhead notifications", position=1, closedByDefault=true)
    public static final String overheadSection = "overheadSection";
    @ConfigSection(name="Overlay", description="The options that control the overlay notifications", position=2, closedByDefault=true)
    public static final String overlaySection = "overlaySection";
    @ConfigSection(name="Screen Flash", description="The options that control the screen flash notifications", position=3, closedByDefault=true)
    public static final String screenFlashSection = "screenFlashSection";
    @ConfigSection(name="Custom Sound", description="The options that control the custom sound notifications", position=4, closedByDefault=true)
    public static final String soundSection = "soundSection";
    @ConfigSection(name="Sound Effect", description="The options that control the custom sound notifications", position=5, closedByDefault=true)
    public static final String soundEffectSection = "soundEffectSection";
    @ConfigSection(name="Text to Speech", description="The options that control the text to speech notifications", position=6, closedByDefault=true)
    public static final String ttsSection = "ttsSection";

    @ConfigItem(keyName="alerts", name="Alerts", description="Serialized Alerts as a JSON string", hidden=true)
    default public String alerts() {
        return "[]";
    }

    @ConfigItem(keyName="pluginVersion", name="Plugin Version", description="Last version of the plugin loaded", hidden=true)
    default public String pluginVersion() {
        return null;
    }

    @ConfigItem(keyName="enableTTS", name="Enable TTS", description="Enables the TTS Notification Type", warning="Using TTS will submit your IP address to a 3rd party website not controlled or verified by the RuneLite Developers.")
    default public boolean ttsEnabled() {
        return false;
    }

    @ConfigItem(keyName="overrideImportsWithDefaults", name="Override Imports with Defaults", description="Will override imported alerts with your defaults set here")
    default public boolean overrideImportsWithDefaults() {
        return false;
    }

    @ConfigItem(keyName="putSoundsIntoQueue", name="Put Sounds Into Queue", description="When this is on, all sounds will be queued up so that they will not overlap")
    default public boolean putSoundsIntoQueue() {
        return true;
    }

    @ConfigItem(keyName="defaultAFKMode", name="Default AFK Mode", description="The default AFK mode on/off", section="afkNotificationSection")
    default public boolean defaultAFKMode() {
        return false;
    }

    @ConfigItem(keyName="defaultAFKSeconds", name="Default AFK Seconds", description="The default AFK seconds value", section="afkNotificationSection")
    @Units(value="s")
    @Range(min=1)
    default public int defaultAFKSeconds() {
        return 5;
    }

    @ConfigItem(keyName="defaultOverheadDisplayTime", name="Default Display Time", description="The default display time", section="overheadSection")
    @Units(value="s")
    default public int defaultOverHeadDisplayTime() {
        return 3;
    }

    @ConfigItem(keyName="overlayLayer", name="Overlay Layer", description="Which layer the overlay renders on. ABOVE_WIDGETS is default", section="overlaySection", position=0)
    default public OverlayLayer overlayLayer() {
        return OverlayLayer.ABOVE_WIDGETS;
    }

    @ConfigItem(keyName="overlayFontType", name="Overlay Font Type", description="Configures which font type is used for the overlay notifications", section="overlaySection", position=1)
    default public FontType overlayFontType() {
        return FontType.BOLD;
    }

    @ConfigItem(keyName="overlayShowTime", name="Overlay Show Time", description="Shows how long ago the notification was fired on the overlay", section="overlaySection", position=2)
    default public boolean overlayShowTime() {
        return true;
    }

    @ConfigItem(keyName="defaultOverlaySticky", name="Default Sticky", description="The default sticky", section="overlaySection", position=3)
    default public boolean defaultOverlaySticky() {
        return false;
    }

    @ConfigItem(keyName="defaultOverlayTTL", name="Default Display Time", description="The default time to display", section="overlaySection", position=4)
    @Units(value="s")
    default public int defaultOverlayTTL() {
        return 5;
    }

    @ConfigItem(keyName="defaultOverlayTextColor", name="Default Text Color", description="The default text color", section="overlaySection", position=5)
    default public Color defaultOverlayTextColor() {
        return DEFAULT_NOTIFICATION_TEXT_COLOR;
    }

    @ConfigItem(keyName="defaultOverlayColor", name="Default Background Color", description="The default background color", section="overlaySection", position=6)
    @Alpha
    default public Color defaultOverlayColor() {
        return DEFAULT_NOTIFICATION_COLOR;
    }

    @ConfigItem(keyName="defaultOverlayImagePath", name="Default Image Path", description="The default image path", section="overlaySection", position=7)
    default public String defaultOverlayImagePath() {
        return "";
    }

    @ConfigItem(keyName="mouseMovementCancelsFlash", name="Mouse Movement Cancels", description="Cancel the screen flash with mouse movement as well as click and keyboard", section="screenFlashSection", position=0)
    default public boolean mouseMovementCancels() {
        return true;
    }

    @ConfigItem(keyName="defaultScreenFlashColor", name="Default Color", description="The default color", section="screenFlashSection", position=1)
    @Alpha
    default public Color defaultScreenFlashColor() {
        return DEFAULT_NOTIFICATION_COLOR;
    }

    @ConfigItem(keyName="defaultScreenFlashType", name="Default Flash Type", description="The default flash type", section="screenFlashSection", position=2)
    default public FlashNotification defaultScreenFlashType() {
        return FlashNotification.SOLID_TWO_SECONDS;
    }

    @ConfigItem(keyName="defaultScreenFlashMode", name="Default Flash Mode", description="The default flash mode", section="screenFlashSection", position=3)
    default public FlashMode defaultScreenFlashMode() {
        return FlashMode.FLASH;
    }

    @ConfigItem(keyName="defaultScreenFlashDuration", name="Default Flash Duration", description="The default flash duration in seconds", section="screenFlashSection", position=3)
    @Units(value="s")
    default public int defaultScreenFlashDuration() {
        return 2;
    }

    @ConfigItem(keyName="defaultSoundVolume", name="Default Volume", description="The default volume", section="soundSection")
    @Range(min=0, max=10)
    default public int defaultSoundVolume() {
        return 8;
    }

    @ConfigItem(keyName="defaultSoundPath", name="Default Path", description="The default path", section="soundSection")
    default public String defaultSoundPath() {
        return null;
    }

    @ConfigItem(keyName="defaultSoundEffectID", name="Default Sound Effect", description="The default sound effect ID", section="soundEffectSection")
    default public int defaultSoundEffectID() {
        return 3925;
    }

    @ConfigItem(keyName="defaultSoundEffectVolume", name="Default Volume", description="The default volume", section="soundEffectSection")
    @Range(min=0, max=10)
    default public int defaultSoundEffectVolume() {
        return 8;
    }

    @ConfigItem(keyName="defaultTTSVolume", name="Default Volume", description="The default volume", section="ttsSection")
    @Range(min=0, max=10)
    default public int defaultTTSVolume() {
        return 5;
    }

    @ConfigItem(keyName="defaultTTSSource", name="Default Source", description="The default source (Eleven Labs needs your own API Key)", section="ttsSection")
    default public TTSSource defaultTTSSource() {
        return TTSSource.LEGACY;
    }

    @ConfigItem(keyName="defaultTTSVoice", name="Default Legacy Voice", description="The default legacy voice", section="ttsSection")
    default public Voice defaultTTSVoice() {
        return Voice.GEORGE;
    }

    @ConfigItem(keyName="defaultTTSRate", name="Default Rate", description="The default rate", section="ttsSection")
    @Range(min=1, max=5)
    default public int defaultTTSRate() {
        return 1;
    }

    @ConfigItem(keyName="elevenLabsAPIKey", name="Eleven Labs API Key", description="Enter your API key", section="ttsSection")
    default public String elevenLabsAPIKey() {
        return "";
    }

    @ConfigItem(keyName="defaultElevenLabsVoice", name="Default Eleven Labs Voice", description="Matches on the name of the voice exactly", section="ttsSection")
    default public String defaultElevenLabsVoice() {
        return null;
    }
}

