/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.google.common.base.Splitter;
import java.text.Normalizer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.client.util.Text;

public class Util {
    private static final Splitter SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();

    public static <T> T defaultArg(T thing, T defaultValue) {
        if (thing instanceof String) {
            String string = (String)thing;
            return string.isEmpty() ? defaultValue : thing;
        }
        return thing != null ? thing : defaultValue;
    }

    public static String createRegexFromGlob(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static String humanReadableClass(Object obj) {
        return Util.splitCamelCase(obj.getClass().getSimpleName());
    }

    public static String processTriggerValues(String string, String[] triggerValues) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < triggerValues.length; ++i) {
            string = string.replaceAll("\\$" + (i + 1), triggerValues[i]);
        }
        return string;
    }

    public static int scale(int val, float srcMin, float srcMax, float destMin, float destMax) {
        return Math.round(((float)val - srcMin) / (srcMax - srcMin) * (destMax - destMin) + destMin);
    }

    public static boolean searchText(String search, List<String> keywords) {
        String normalizedSearch = Normalizer.normalize(search, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase();
        return Text.matchesSearchTerms((Iterable)SPLITTER.split((CharSequence)normalizedSearch), (Collection)keywords.stream().map(term -> Normalizer.normalize(term, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase()).collect(Collectors.toList()));
    }
}

