/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.alerts.ChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.InventoryAlert;
import com.adamk33n3r.runelite.watchdog.alerts.NotificationFiredAlert;
import com.adamk33n3r.runelite.watchdog.alerts.PlayerChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.SpawnedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.StatChangedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.XPDropAlert;

public enum TriggerType {
    ALERT_GROUP("Alert Group", "Group alerts together", AlertGroup.class),
    GAME_MESSAGE("Game Message", "Game messages sent in chat", ChatAlert.class),
    PLAYER_CHAT_MESSAGE("Player Chat Message", "Player messages sent in chat", PlayerChatAlert.class),
    STAT_CHANGED("Stat Changed", "Stat changes like boosts or drains", StatChangedAlert.class),
    XP_DROP("XP Drop", "Get an xp drop", XPDropAlert.class),
    SPAWNED_OBJECT("Spawned Object", "When an object, player, or npc spawns or despawns", SpawnedAlert.class),
    INVENTORY("Inventory", "When your inventory is full, empty, or contains certain items", InventoryAlert.class),
    NOTIFICATION_FIRED("Notification Fired", "When other plugins fire notifications", NotificationFiredAlert.class);

    private final String name;
    private final String tooltip;
    private final Class<? extends Alert> implClass;

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Class<? extends Alert> getImplClass() {
        return this.implClass;
    }

    private TriggerType(String name, String tooltip, Class<? extends Alert> implClass) {
        this.name = name;
        this.tooltip = tooltip;
        this.implClass = implClass;
    }
}

