/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import jaco.mp3.player.MP3Player;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundPlayer {
    private static final Logger log = LoggerFactory.getLogger(SoundPlayer.class);
    @Inject
    private ScheduledExecutorService executor;
    private final MP3Player mp3Player;
    private final Queue<Pair<File, Integer>> queue = new ConcurrentLinkedQueue<Pair<File, Integer>>();
    private boolean mp3IsPlaying = false;
    private boolean clipIsPlaying = false;

    public SoundPlayer() {
        this.mp3Player = this.createMP3Player();
    }

    public void clearQueue() {
        this.queue.clear();
    }

    public void processQueue() {
        if (!this.clipIsPlaying && this.mp3IsPlaying && this.mp3Player.isStopped()) {
            this.mp3IsPlaying = false;
        }
        if (this.mp3IsPlaying || this.clipIsPlaying) {
            return;
        }
        this.playNext(this.mp3Player);
    }

    public void play(File soundFile, int volume) {
        this.queue.add((Pair<File, Integer>)Pair.of((Object)soundFile, (Object)volume));
        if (!WatchdogPlugin.getInstance().getConfig().putSoundsIntoQueue()) {
            SwingUtilities.invokeLater(() -> this.playNext(this.createMP3Player()));
        }
    }

    private void playNext(MP3Player mp3Player) {
        Pair<File, Integer> nextSound = this.queue.poll();
        if (nextSound == null) {
            return;
        }
        if (!((File)nextSound.getLeft()).exists()) {
            log.error(String.format("File not found: %s", ((File)nextSound.getLeft()).getAbsolutePath()));
            this.clipIsPlaying = true;
            Toolkit.getDefaultToolkit().beep();
            this.executor.schedule(() -> {
                this.clipIsPlaying = false;
                return false;
            }, 1L, TimeUnit.SECONDS);
            return;
        }
        log.debug(String.format("Now playing: %s", ((File)nextSound.getLeft()).getAbsolutePath()));
        if (((File)nextSound.getLeft()).getName().endsWith(".mp3")) {
            mp3Player.getPlayList().clear();
            mp3Player.add((File)nextSound.getLeft());
            mp3Player.setVolume((Integer)nextSound.getRight() * 10);
            this.mp3IsPlaying = true;
            mp3Player.play();
        } else {
            try {
                Clip clip = AudioSystem.getClip();
                try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream((File)nextSound.getLeft()));
                     AudioInputStream sound = AudioSystem.getAudioInputStream(fileStream);){
                    clip.open(sound);
                    FloatControl volumeFC = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                    int decibels = Util.scale((Integer)nextSound.getRight(), 0.0f, 10.0f, -25.0f, 5.0f);
                    volumeFC.setValue(decibels);
                    this.clipIsPlaying = true;
                    clip.loop(0);
                    clip.addLineListener(event -> {
                        if (event.getType() == LineEvent.Type.STOP) {
                            this.clipIsPlaying = false;
                            clip.close();
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("Unable to load sound", (Throwable)e);
                    clip.close();
                }
            }
            catch (Exception e) {
                log.error("Error trying to create clip", (Throwable)e);
            }
        }
    }

    private MP3Player createMP3Player() {
        MP3Player mp3Player = new MP3Player();
        mp3Player.setRepeat(false);
        return mp3Player;
    }
}

