/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.notifications.GameMessage;
import com.adamk33n3r.runelite.watchdog.notifications.Notification;
import com.adamk33n3r.runelite.watchdog.notifications.NotificationEvent;
import com.adamk33n3r.runelite.watchdog.notifications.Overhead;
import com.adamk33n3r.runelite.watchdog.notifications.Overlay;
import com.adamk33n3r.runelite.watchdog.notifications.ScreenFlash;
import com.adamk33n3r.runelite.watchdog.notifications.Sound;
import com.adamk33n3r.runelite.watchdog.notifications.SoundEffect;
import com.adamk33n3r.runelite.watchdog.notifications.TextToSpeech;
import com.adamk33n3r.runelite.watchdog.notifications.TrayNotification;

public enum NotificationType {
    GAME_MESSAGE("Game Message", "Put a game message in your chat", GameMessage.class),
    SCREEN_FLASH("Screen Flash", "Flash your screen a custom color", ScreenFlash.class),
    SOUND_EFFECT("Sound Effect", "Play a builtin sound effect", SoundEffect.class),
    SOUND("Custom Sound", "Play a custom sound", Sound.class),
    TEXT_TO_SPEECH("Text to Speech", "Synthesize speech", TextToSpeech.class),
    TRAY_NOTIFICATION("Tray Notification", "Create a tray notification", TrayNotification.class),
    OVERHEAD("Overhead", "Display overhead text", Overhead.class),
    OVERLAY("Overlay", "Create an overlay notification", Overlay.class),
    NOTIFICATION_EVENT("Notification Event", "Fire a NotificationFired event so that other plugins may hook into it e.g. RL Tray Notifications", NotificationEvent.class);

    private final String name;
    private final String tooltip;
    private final Class<? extends Notification> implClass;

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Class<? extends Notification> getImplClass() {
        return this.implClass;
    }

    private NotificationType(String name, String tooltip, Class<? extends Notification> implClass) {
        this.name = name;
        this.tooltip = tooltip;
        this.implClass = implClass;
    }
}

