/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.CenteredImageComponent;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.WrappedTitleComponent;
import com.adamk33n3r.runelite.watchdog.notifications.Overlay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class NotificationOverlay
extends OverlayPanel {
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private WatchdogConfig config;
    private final ConcurrentLinkedQueue<OverlayNotificationData> overlayNotificationQueue = new ConcurrentLinkedQueue();
    private static final Dimension DEFAULT_SIZE = new Dimension(250, 60);
    static final String CLEAR = "Clear All";

    @Inject
    public NotificationOverlay(WatchdogPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setResizable(true);
        this.setPriority(OverlayPriority.LOW);
        this.setClearChildren(true);
        this.setPreferredSize(DEFAULT_SIZE);
        this.panelComponent.setWrap(false);
        this.panelComponent.setBorder(new Rectangle(0, 0, 0, 0));
        this.panelComponent.setGap(new Point(0, 6));
        this.panelComponent.setBackgroundColor(new Color(0, 0, 0, 0));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Watchdog Notification overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, CLEAR, "Watchdog Notification overlay"));
    }

    public void add(Overlay overlayNotification, String message) {
        this.overlayNotificationQueue.add(new OverlayNotificationData(overlayNotification, message));
    }

    public void clear() {
        this.overlayNotificationQueue.clear();
    }

    public Dimension render(Graphics2D graphics) {
        this.setLayer(this.config.overlayLayer());
        graphics.setFont(this.config.overlayFontType().getFont());
        this.panelComponent.getChildren().add(TitleComponent.builder().text("").build());
        if (this.overlayNotificationQueue.isEmpty()) {
            return super.render(graphics);
        }
        if (this.getPreferredSize() == null) {
            this.setPreferredSize(DEFAULT_SIZE);
        }
        this.overlayNotificationQueue.removeIf(OverlayNotificationData::isExpired);
        while (this.overlayNotificationQueue.size() > 5) {
            this.overlayNotificationQueue.poll();
        }
        this.overlayNotificationQueue.forEach(notif -> this.panelComponent.getChildren().add(notif));
        return super.render(graphics);
    }

    private class OverlayNotificationData
    extends PanelComponent {
        private final Instant timeStarted;
        private final Overlay overlayNotification;
        private final String message;
        private BufferedImage image;

        public OverlayNotificationData(Overlay overlayNotification, String message) {
            this.overlayNotification = overlayNotification;
            if (overlayNotification.getImagePath() != null && !overlayNotification.getImagePath().isEmpty()) {
                try {
                    this.image = ImageUtil.resizeImage((BufferedImage)ImageIO.read(new File(overlayNotification.getImagePath())), (int)128, (int)128, (boolean)true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.message = message;
            this.timeStarted = Instant.now();
            this.setWrap(false);
        }

        public boolean isExpired() {
            return !this.overlayNotification.isSticky() && this.timeStarted.plus(Duration.ofSeconds(this.overlayNotification.getTimeToLive())).isBefore(Instant.now());
        }

        public Dimension render(Graphics2D graphics) {
            this.setBackgroundColor(this.overlayNotification.getColor());
            this.getChildren().clear();
            this.getChildren().add(WrappedTitleComponent.builder().text(this.message).color(this.overlayNotification.getTextColor()).preferredSize(this.getPreferredSize()).build());
            if (this.image != null) {
                this.getChildren().add(new CenteredImageComponent(this.image));
            }
            if (NotificationOverlay.this.config.overlayShowTime()) {
                this.getChildren().add(WrappedTitleComponent.builder().text(DurationFormatUtils.formatDuration((long)ChronoUnit.MILLIS.between(this.timeStarted, Instant.now()), (String)"m'm' s's' 'ago'")).color(this.overlayNotification.getTextColor()).preferredSize(this.getPreferredSize()).build());
            }
            return super.render(graphics);
        }
    }
}

