/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.alerts.FlashMode;
import com.adamk33n3r.runelite.watchdog.notifications.ScreenFlash;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(FlashOverlay.class);
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private WatchdogConfig config;
    private Instant flashStart;
    private int gameCycleStart;
    private long mouseLastPressedMillis;
    private ScreenFlash screenFlash;
    private static final int MIN_MILLISECONDS_BEFORE_CANCELLED = 2000;

    public FlashOverlay() {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public void flash(ScreenFlash screenFlash) {
        this.screenFlash = screenFlash;
        this.flashStart = Instant.now();
        this.gameCycleStart = this.client.getGameCycle();
        this.mouseLastPressedMillis = this.client.getMouseLastPressedMillis();
    }

    public Dimension render(Graphics2D graphics) {
        if (this.flashStart == null) {
            return null;
        }
        if (this.screenFlash.getFlashDuration() == 0) {
            if (Instant.now().minusMillis(2000L).isAfter(this.flashStart) && (this.client.getMouseIdleTicks() < 100 && this.config.mouseMovementCancels() || this.client.getKeyboardIdleTicks() < 100 || this.client.getMouseLastPressedMillis() > this.mouseLastPressedMillis) && this.clientUI.isFocused()) {
                this.flashStart = null;
                return null;
            }
        } else if (Instant.now().minusSeconds(this.screenFlash.getFlashDuration()).isAfter(this.flashStart)) {
            this.flashStart = null;
            return null;
        }
        if ((this.client.getGameCycle() - this.gameCycleStart) % 40 >= 20 && this.screenFlash.getFlashMode() == FlashMode.FLASH) {
            return null;
        }
        graphics.setColor(this.screenFlash.getColor());
        graphics.fill(new Rectangle(this.client.getCanvas().getSize()));
        return null;
    }
}

