/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.AlertManager;
import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.alerts.ChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.InventoryAlert;
import com.adamk33n3r.runelite.watchdog.alerts.NotificationFiredAlert;
import com.adamk33n3r.runelite.watchdog.alerts.PlayerChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.RegexMatcher;
import com.adamk33n3r.runelite.watchdog.alerts.SpawnedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.StatChangedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.XPDropAlert;
import com.adamk33n3r.runelite.watchdog.ui.panels.HistoryPanel;
import java.awt.TrayIcon;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Skill;
import net.runelite.api.TileObject;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventHandler {
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private AlertManager alertManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private Provider<HistoryPanel> historyPanelProvider;
    private final Map<Alert, Instant> lastTriggered = new HashMap<Alert, Instant>();
    private final Map<Skill, Integer> previousSkillLevelTable = new EnumMap<Skill, Integer>(Skill.class);
    private final Map<Skill, Integer> previousSkillXPTable = new EnumMap<Skill, Integer>(Skill.class);
    private boolean ignoreNotificationFired = false;

    public synchronized void notify(String message) {
        this.ignoreNotificationFired = true;
        this.eventBus.post((Object)new NotificationFired(message, TrayIcon.MessageType.NONE));
        this.ignoreNotificationFired = false;
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getName().equals(WatchdogPlugin.getInstance().getName())) {
            return;
        }
        String unformattedMessage = Text.removeFormattingTags((String)chatMessage.getMessage());
        if (chatMessage.getType() == ChatMessageType.PUBLICCHAT || chatMessage.getType() == ChatMessageType.AUTOTYPER || chatMessage.getType() == ChatMessageType.PRIVATECHAT || chatMessage.getType() == ChatMessageType.PRIVATECHATOUT || chatMessage.getType() == ChatMessageType.MODCHAT || chatMessage.getType() == ChatMessageType.MODPRIVATECHAT || chatMessage.getType() == ChatMessageType.MODAUTOTYPER || chatMessage.getType() == ChatMessageType.FRIENDSCHAT || chatMessage.getType() == ChatMessageType.CLAN_CHAT || chatMessage.getType() == ChatMessageType.CLAN_GUEST_CHAT || chatMessage.getType() == ChatMessageType.CLAN_GIM_CHAT) {
            this.alertManager.getAllEnabledAlertsOfType(PlayerChatAlert.class).forEach(chatAlert -> {
                String[] groups = this.matchPattern((RegexMatcher)chatAlert, unformattedMessage);
                if (groups == null) {
                    return;
                }
                this.fireAlert((Alert)chatAlert, groups);
            });
            return;
        }
        this.alertManager.getAllEnabledAlertsOfType(ChatAlert.class).forEach(gameAlert -> {
            String[] groups = this.matchPattern((RegexMatcher)gameAlert, unformattedMessage);
            if (groups == null) {
                return;
            }
            this.fireAlert((Alert)gameAlert, groups);
        });
    }

    @Subscribe
    public void onNotificationFired(NotificationFired notificationFired) {
        if (this.ignoreNotificationFired) {
            return;
        }
        this.alertManager.getAllEnabledAlertsOfType(NotificationFiredAlert.class).forEach(notificationFiredAlert -> {
            String[] groups = this.matchPattern((RegexMatcher)notificationFiredAlert, notificationFired.getMessage());
            if (groups == null) {
                return;
            }
            this.fireAlert((Alert)notificationFiredAlert, groups);
        });
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            for (Skill skill : Skill.values()) {
                this.previousSkillLevelTable.put(skill, this.client.getBoostedSkillLevel(skill));
                this.previousSkillXPTable.put(skill, this.client.getSkillExperience(skill));
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        this.handleStatChanged(statChanged);
        this.handleXPDrop(statChanged);
    }

    private void handleStatChanged(StatChanged statChanged) {
        Integer previousLevel = this.previousSkillLevelTable.put(statChanged.getSkill(), statChanged.getBoostedLevel());
        if (previousLevel == null) {
            return;
        }
        this.alertManager.getAllEnabledAlertsOfType(StatChangedAlert.class).filter(alert -> {
            boolean isSkill;
            boolean bl = isSkill = alert.getSkill() == statChanged.getSkill();
            if (!isSkill) {
                return false;
            }
            int targetLevel = statChanged.getLevel() + alert.getChangedAmount();
            boolean isNegative = alert.getChangedAmount() < 0;
            boolean isLower = statChanged.getBoostedLevel() <= targetLevel;
            boolean wasHigher = previousLevel > targetLevel;
            boolean isHigher = statChanged.getBoostedLevel() >= targetLevel;
            boolean wasLower = previousLevel < targetLevel;
            return isNegative && isLower && wasHigher || !isNegative && isHigher && wasLower;
        }).forEach(alert -> this.fireAlert((Alert)alert, statChanged.getSkill().getName()));
    }

    private void handleXPDrop(StatChanged statChanged) {
        Integer previousXP = this.previousSkillXPTable.put(statChanged.getSkill(), statChanged.getXp());
        if (previousXP == null) {
            return;
        }
        this.alertManager.getAllEnabledAlertsOfType(XPDropAlert.class).filter(alert -> {
            boolean isSkill = alert.getSkill() == statChanged.getSkill();
            int gainedXP = statChanged.getXp() - previousXP;
            return isSkill && gainedXP >= alert.getGainedAmount();
        }).forEach(alert -> this.fireAlert((Alert)alert, statChanged.getSkill().getName()));
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getItemContainer().getId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        this.alertManager.getAllEnabledAlertsOfType(InventoryAlert.class).forEach(inventoryAlert -> {
            Item[] items = itemContainerChanged.getItemContainer().getItems();
            long itemCount = Arrays.stream(items).filter(item -> item.getId() > -1).count();
            if (inventoryAlert.getInventoryAlertType() == InventoryAlert.InventoryAlertType.FULL && itemCount == 28L) {
                this.fireAlert((Alert)inventoryAlert, inventoryAlert.getInventoryAlertType().getName());
            } else if (inventoryAlert.getInventoryAlertType() == InventoryAlert.InventoryAlertType.EMPTY && itemCount == 0L) {
                this.fireAlert((Alert)inventoryAlert, inventoryAlert.getInventoryAlertType().getName());
            } else if (inventoryAlert.getInventoryAlertType() == InventoryAlert.InventoryAlertType.ITEM) {
                HashMap allItems = new HashMap();
                Arrays.stream(items).forEach(item -> allItems.merge(item.getId(), item.getQuantity(), Integer::sum));
                allItems.entrySet().stream().filter(itemWithCount -> inventoryAlert.getItemQuantity() == 0 || ((Integer)itemWithCount.getValue()).intValue() == inventoryAlert.getItemQuantity()).map(itemWithCount -> this.matchPattern((RegexMatcher)inventoryAlert, this.itemManager.getItemComposition(((Integer)itemWithCount.getKey()).intValue()).getName())).filter(Objects::nonNull).findFirst().ifPresent(groups -> this.fireAlert((Alert)inventoryAlert, (String[])groups));
            }
        });
    }

    @Subscribe
    private void onItemSpawned(ItemSpawned itemSpawned) {
        ItemComposition comp = this.itemManager.getItemComposition(itemSpawned.getItem().getId());
        this.onSpawned(comp.getName(), SpawnedAlert.SpawnedDespawned.SPAWNED, SpawnedAlert.SpawnedType.ITEM);
    }

    @Subscribe
    private void onItemDespawned(ItemDespawned itemDespawned) {
        ItemComposition comp = this.itemManager.getItemComposition(itemDespawned.getItem().getId());
        this.onSpawned(comp.getName(), SpawnedAlert.SpawnedDespawned.DESPAWNED, SpawnedAlert.SpawnedType.ITEM);
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned npcSpawned) {
        this.onActorSpawned((Actor)npcSpawned.getNpc(), SpawnedAlert.SpawnedType.NPC);
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned npcDespawned) {
        this.onActorDespawned((Actor)npcDespawned.getNpc(), SpawnedAlert.SpawnedType.NPC);
    }

    @Subscribe
    private void onPlayerSpawned(PlayerSpawned playerSpawned) {
        this.onActorSpawned((Actor)playerSpawned.getPlayer(), SpawnedAlert.SpawnedType.PLAYER);
    }

    @Subscribe
    private void onPlayerDespawned(PlayerDespawned playerDespawned) {
        this.onActorDespawned((Actor)playerDespawned.getPlayer(), SpawnedAlert.SpawnedType.PLAYER);
    }

    private void onActorSpawned(Actor actor, SpawnedAlert.SpawnedType type) {
        this.onSpawned(actor.getName(), SpawnedAlert.SpawnedDespawned.SPAWNED, type);
    }

    private void onActorDespawned(Actor actor, SpawnedAlert.SpawnedType type) {
        this.onSpawned(actor.getName(), SpawnedAlert.SpawnedDespawned.DESPAWNED, type);
    }

    @Subscribe
    private void onGroundObjectSpawned(GroundObjectSpawned groundObjectSpawned) {
        this.onTileObjectSpawned((TileObject)groundObjectSpawned.getGroundObject(), SpawnedAlert.SpawnedDespawned.SPAWNED, SpawnedAlert.SpawnedType.GROUND_OBJECT);
    }

    @Subscribe
    private void onGroundObjectDespawned(GroundObjectDespawned groundObjectDespawned) {
        this.onTileObjectSpawned((TileObject)groundObjectDespawned.getGroundObject(), SpawnedAlert.SpawnedDespawned.DESPAWNED, SpawnedAlert.SpawnedType.GROUND_OBJECT);
    }

    @Subscribe
    private void onDecorativeObjectSpawned(DecorativeObjectSpawned decorativeObjectSpawned) {
        this.onTileObjectSpawned((TileObject)decorativeObjectSpawned.getDecorativeObject(), SpawnedAlert.SpawnedDespawned.SPAWNED, SpawnedAlert.SpawnedType.DECORATIVE_OBJECT);
    }

    @Subscribe
    private void onDecorativeObjectDespawned(DecorativeObjectDespawned decorativeObjectDespawned) {
        this.onTileObjectSpawned((TileObject)decorativeObjectDespawned.getDecorativeObject(), SpawnedAlert.SpawnedDespawned.DESPAWNED, SpawnedAlert.SpawnedType.DECORATIVE_OBJECT);
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        this.onTileObjectSpawned((TileObject)gameObjectSpawned.getGameObject(), SpawnedAlert.SpawnedDespawned.SPAWNED, SpawnedAlert.SpawnedType.GAME_OBJECT);
    }

    @Subscribe
    private void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        this.onTileObjectSpawned((TileObject)gameObjectDespawned.getGameObject(), SpawnedAlert.SpawnedDespawned.DESPAWNED, SpawnedAlert.SpawnedType.GAME_OBJECT);
    }

    @Subscribe
    private void onWallObjectSpawned(WallObjectSpawned wallObjectSpawned) {
        this.onTileObjectSpawned((TileObject)wallObjectSpawned.getWallObject(), SpawnedAlert.SpawnedDespawned.SPAWNED, SpawnedAlert.SpawnedType.WALL_OBJECT);
    }

    @Subscribe
    private void onWallObjectDespawned(WallObjectDespawned wallObjectDespawned) {
        this.onTileObjectSpawned((TileObject)wallObjectDespawned.getWallObject(), SpawnedAlert.SpawnedDespawned.DESPAWNED, SpawnedAlert.SpawnedType.WALL_OBJECT);
    }

    private void onTileObjectSpawned(TileObject tileObject, SpawnedAlert.SpawnedDespawned mode, SpawnedAlert.SpawnedType type) {
        ObjectComposition impostor;
        ObjectComposition comp = this.client.getObjectDefinition(tileObject.getId());
        ObjectComposition objectComposition = impostor = comp.getImpostorIds() != null ? comp.getImpostor() : comp;
        if (impostor == null) {
            return;
        }
        this.onSpawned(impostor.getName(), mode, type);
    }

    private void onSpawned(String name, SpawnedAlert.SpawnedDespawned mode, SpawnedAlert.SpawnedType type) {
        String unformattedName = Text.removeFormattingTags((String)name);
        this.alertManager.getAllEnabledAlertsOfType(SpawnedAlert.class).filter(spawnedAlert -> spawnedAlert.getSpawnedDespawned() == mode).filter(spawnedAlert -> spawnedAlert.getSpawnedType() == type).forEach(spawnedAlert -> {
            String[] groups = this.matchPattern((RegexMatcher)spawnedAlert, unformattedName);
            if (groups == null) {
                return;
            }
            this.fireAlert((Alert)spawnedAlert, groups);
        });
    }

    private String[] matchPattern(RegexMatcher regexMatcher, String input) {
        String regex = regexMatcher.isRegexEnabled() ? regexMatcher.getPattern() : Util.createRegexFromGlob(regexMatcher.getPattern());
        Matcher matcher = Pattern.compile(regex, regexMatcher.isRegexEnabled() ? 0 : 2).matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String[] groups = new String[matcher.groupCount()];
        for (int i = 0; i < matcher.groupCount(); ++i) {
            groups[i] = matcher.group(i + 1);
        }
        return groups;
    }

    private void fireAlert(Alert alert, String triggerValue) {
        this.fireAlert(alert, new String[]{triggerValue});
    }

    private void fireAlert(Alert alert, String[] triggerValues) {
        Alert alertToDebounceWith;
        if (!alert.isEnabled()) {
            return;
        }
        List<AlertGroup> ancestors = alert.getAncestors();
        if (ancestors != null && !ancestors.stream().allMatch(Alert::isEnabled)) {
            return;
        }
        Alert alert2 = alertToDebounceWith = ancestors == null ? alert : Stream.concat(ancestors.stream(), Stream.of(alert)).filter(ancestor -> ancestor.getDebounceTime() > 0).max(Comparator.comparingInt(Alert::getDebounceTime)).orElse(alert);
        if (!this.lastTriggered.containsKey(alertToDebounceWith) || Instant.now().compareTo(this.lastTriggered.get(alertToDebounceWith).plusMillis(alertToDebounceWith.getDebounceTime())) >= 0) {
            SwingUtilities.invokeLater(() -> ((HistoryPanel)((Object)((Object)this.historyPanelProvider.get()))).addEntry(alert, triggerValues));
            this.lastTriggered.put(alertToDebounceWith, Instant.now());
            alert.getNotifications().forEach(notification -> notification.fire(triggerValues));
        }
    }
}

