/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class CenteredImageComponent
implements LayoutableRenderableEntity {
    private final BufferedImage image;
    private final Rectangle bounds = new Rectangle();
    private Point preferredLocation = new Point();
    private Dimension preferredSize = new Dimension();

    public Dimension render(Graphics2D graphics) {
        if (this.image == null) {
            return null;
        }
        graphics.drawImage((Image)this.image, this.preferredLocation.x + this.preferredSize.width / 2 - this.image.getWidth() / 2, this.preferredLocation.y, null);
        Dimension dimension = new Dimension(this.image.getWidth(), this.image.getHeight());
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    public CenteredImageComponent(BufferedImage image) {
        this.image = image;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }
}

