/*
 * Decompiled with CFR 0.152.
 */
package com.adamk33n3r.runelite.watchdog;

import com.adamk33n3r.runelite.watchdog.MixedCaseEnumAdapter;
import com.adamk33n3r.runelite.watchdog.RuntimeTypeAdapterFactory;
import com.adamk33n3r.runelite.watchdog.Util;
import com.adamk33n3r.runelite.watchdog.Version;
import com.adamk33n3r.runelite.watchdog.WatchdogConfig;
import com.adamk33n3r.runelite.watchdog.WatchdogPanel;
import com.adamk33n3r.runelite.watchdog.WatchdogPlugin;
import com.adamk33n3r.runelite.watchdog.alerts.Alert;
import com.adamk33n3r.runelite.watchdog.alerts.AlertGroup;
import com.adamk33n3r.runelite.watchdog.alerts.ChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.FlashMode;
import com.adamk33n3r.runelite.watchdog.alerts.InventoryAlert;
import com.adamk33n3r.runelite.watchdog.alerts.NotificationFiredAlert;
import com.adamk33n3r.runelite.watchdog.alerts.PlayerChatAlert;
import com.adamk33n3r.runelite.watchdog.alerts.RegexMatcher;
import com.adamk33n3r.runelite.watchdog.alerts.SpawnedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.StatChangedAlert;
import com.adamk33n3r.runelite.watchdog.alerts.StatDrainAlert;
import com.adamk33n3r.runelite.watchdog.alerts.XPDropAlert;
import com.adamk33n3r.runelite.watchdog.hub.AlertHubCategory;
import com.adamk33n3r.runelite.watchdog.notifications.GameMessage;
import com.adamk33n3r.runelite.watchdog.notifications.IAudioNotification;
import com.adamk33n3r.runelite.watchdog.notifications.INotification;
import com.adamk33n3r.runelite.watchdog.notifications.Notification;
import com.adamk33n3r.runelite.watchdog.notifications.NotificationEvent;
import com.adamk33n3r.runelite.watchdog.notifications.Overhead;
import com.adamk33n3r.runelite.watchdog.notifications.Overlay;
import com.adamk33n3r.runelite.watchdog.notifications.ScreenFlash;
import com.adamk33n3r.runelite.watchdog.notifications.Sound;
import com.adamk33n3r.runelite.watchdog.notifications.SoundEffect;
import com.adamk33n3r.runelite.watchdog.notifications.TextToSpeech;
import com.adamk33n3r.runelite.watchdog.notifications.TrayNotification;
import com.adamk33n3r.runelite.watchdog.ui.panels.PanelUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.awt.Component;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import joptsimple.internal.Strings;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.FlashNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertManager {
    private static final Logger log = LoggerFactory.getLogger(AlertManager.class);
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson clientGson;
    private Gson gson;
    @Inject
    private WatchdogConfig watchdogConfig;
    private final List<Alert> alerts = new CopyOnWriteArrayList<Alert>();
    @Inject
    private WatchdogPanel watchdogPanel;
    @Inject
    @Named(value="watchdog.pluginVersion")
    private String pluginVersion;
    public static final Type ALERT_TYPE = new TypeToken<Alert>(){}.getType();
    public static final Type ALERT_LIST_TYPE = new TypeToken<List<Alert>>(){}.getType();

    @Inject
    private void init() {
        RuntimeTypeAdapterFactory<AlertGroup> alertTypeFactory = RuntimeTypeAdapterFactory.of(Alert.class).ignoreSubtype("IdleAlert").ignoreSubtype("ResourceAlert").ignoreSubtype("SoundFiredAlert").ignoreSubtype("AlertGroup").recognizeSubtypes().registerSubtype(ChatAlert.class).registerSubtype(PlayerChatAlert.class).registerSubtype(NotificationFiredAlert.class).registerSubtype(StatDrainAlert.class).registerSubtype(StatChangedAlert.class).registerSubtype(XPDropAlert.class).registerSubtype(SpawnedAlert.class).registerSubtype(InventoryAlert.class).registerSubtype(AlertGroup.class);
        RuntimeTypeAdapterFactory<NotificationEvent> notificationTypeFactory = RuntimeTypeAdapterFactory.of(Notification.class).registerSubtype(TrayNotification.class).registerSubtype(TextToSpeech.class).registerSubtype(Sound.class).registerSubtype(SoundEffect.class).registerSubtype(ScreenFlash.class).registerSubtype(GameMessage.class).registerSubtype(Overhead.class).registerSubtype(Overlay.class).registerSubtype(NotificationEvent.class);
        this.gson = this.clientGson.newBuilder().registerTypeAdapterFactory(alertTypeFactory).registerTypeAdapterFactory(notificationTypeFactory).registerTypeAdapter(AlertHubCategory.class, (Object)new MixedCaseEnumAdapter()).create();
    }

    public Stream<Alert> getAllEnabledAlerts() {
        return this.getAllAlerts().filter(Alert::isEnabled);
    }

    public <T extends Alert> Stream<T> getAllEnabledAlertsOfType(Class<T> type) {
        return this.getAllEnabledAlerts().filter(type::isInstance).map(type::cast);
    }

    public Stream<Alert> getAllAlerts() {
        return this.getAllAlertsFrom(this.alerts.stream(), false);
    }

    public <T extends Alert> Stream<T> getAllAlertsOfType(Class<T> type) {
        return this.getAllAlerts().filter(type::isInstance).map(type::cast);
    }

    public Stream<AlertGroup> getAllAlertGroups() {
        return this.getAllAlertsFrom(this.alerts.stream(), true).filter(AlertGroup.class::isInstance).map(AlertGroup.class::cast);
    }

    public Stream<Alert> getAllAlertsFrom(Stream<Alert> alerts, boolean includeGroups) {
        return alerts.flatMap(alert -> {
            if (alert instanceof AlertGroup) {
                Stream<Alert> children = this.getAllAlertsFrom(((AlertGroup)alert).getAlerts().stream(), includeGroups);
                if (includeGroups) {
                    return Stream.concat(Stream.of(alert), children);
                }
                return children;
            }
            return Stream.of(alert);
        });
    }

    public void addAlert(Alert alert, boolean overrideWithDefaults) {
        this.alerts.add(alert);
        this.setUpAlert(alert, overrideWithDefaults);
        this.saveAlerts();
        SwingUtilities.invokeLater(this.watchdogPanel::rebuild);
    }

    public void removeAlert(Alert alert) {
        AlertGroup parent = alert.getParent();
        if (parent != null) {
            parent.getAlerts().remove(alert);
        } else {
            this.alerts.remove(alert);
        }
        this.saveAlerts();
        SwingUtilities.invokeLater(this.watchdogPanel::rebuild);
    }

    public Alert cloneAlert(Alert alert) {
        String json = this.gson.toJson((Object)alert, ALERT_TYPE);
        Alert clonedAlert = (Alert)this.gson.fromJson(json, ALERT_TYPE);
        clonedAlert.setName(clonedAlert.getName() + " Clone");
        return clonedAlert;
    }

    public void moveAlertTo(Alert alert, int pos) {
        AlertGroup parent = alert.getParent();
        if (parent != null) {
            parent.getAlerts().remove(alert);
            parent.getAlerts().add(pos, alert);
        } else {
            this.alerts.remove(alert);
            this.alerts.add(pos, alert);
        }
        this.saveAlerts();
    }

    public void loadAlerts() {
        String json = this.configManager.getConfiguration("watchdog", "alerts");
        this.importAlerts(json, this.alerts, false, false, false);
        this.handleUpgrades();
    }

    public boolean importAlerts(String json, List<Alert> alerts, boolean append, boolean checkRegex, boolean overrideWithDefaults) throws JsonSyntaxException {
        if (Strings.isNullOrEmpty((String)json)) {
            return false;
        }
        if (!append) {
            alerts.clear();
        }
        Supplier<Stream<Alert>> alertStream = this.tryImport(json);
        if (checkRegex && !alertStream.get().allMatch(alert -> {
            if (alert instanceof RegexMatcher) {
                RegexMatcher matcher = (RegexMatcher)((Object)alert);
                return PanelUtils.isPatternValid((Component)((Object)this.watchdogPanel), matcher.getPattern(), matcher.isRegexEnabled());
            }
            return true;
        })) {
            return false;
        }
        alertStream.get().forEach(alerts::add);
        this.saveAlerts();
        this.getAllAlertsFrom(alertStream.get(), false).forEach(alert -> this.setUpAlert((Alert)alert, overrideWithDefaults));
        SwingUtilities.invokeLater(() -> {
            this.watchdogPanel.rebuild();
            SwingUtilities.invokeLater(this.watchdogPanel::scrollToBottom);
        });
        return true;
    }

    public void saveAlerts() {
        String json = this.gson.toJson(this.alerts, ALERT_LIST_TYPE);
        this.configManager.setConfiguration("watchdog", "alerts", json);
    }

    public String toJSON() {
        return this.gson.toJson(this.alerts, ALERT_LIST_TYPE);
    }

    private Supplier<Stream<Alert>> tryImport(String json) throws JsonSyntaxException {
        try {
            Alert importedAlert = (Alert)this.gson.fromJson(json, ALERT_TYPE);
            return () -> Stream.of(importedAlert).filter(Objects::nonNull);
        }
        catch (JsonSyntaxException importedAlert) {
            List importedAlerts = (List)this.gson.fromJson(json, ALERT_LIST_TYPE);
            return () -> importedAlerts.stream().filter(Objects::nonNull);
        }
    }

    private void setUpAlert(Alert alert, boolean overrideWithDefaults) {
        WatchdogPlugin.getInstance().getInjector().injectMembers((Object)alert);
        if (alert instanceof AlertGroup) {
            ((AlertGroup)alert).getAlerts().forEach(subAlert -> this.setUpAlert((Alert)subAlert, overrideWithDefaults));
        } else {
            for (INotification iNotification : alert.getNotifications()) {
                WatchdogPlugin.getInstance().getInjector().injectMembers((Object)iNotification);
                if (overrideWithDefaults) {
                    iNotification.setDefaults();
                }
                iNotification.setAlert(alert);
            }
        }
    }

    private void handleUpgrades() {
        Version currentVersion = new Version(this.pluginVersion);
        Version configVersion = new Version(this.configManager.getConfiguration("watchdog", "pluginVersion"));
        log.debug("currentVersion: " + currentVersion);
        log.debug("configVersion: " + configVersion);
        if (currentVersion.compareTo(configVersion) > 0) {
            log.debug("Checking if data migration needed");
            if (configVersion.compareTo(new Version("2.4.0")) < 0) {
                log.debug("Need to convert StatDrainAlerts to StatChangedAlerts");
                this.alerts.replaceAll(alert -> {
                    if (alert instanceof StatDrainAlert) {
                        StatDrainAlert statDrainAlert = (StatDrainAlert)alert;
                        StatChangedAlert statChangedAlert = new StatChangedAlert();
                        statChangedAlert.setName(statDrainAlert.getName());
                        statChangedAlert.setEnabled(statDrainAlert.isEnabled());
                        statChangedAlert.setDebounceTime(statDrainAlert.getDebounceTime());
                        statChangedAlert.setSkill(statDrainAlert.getSkill());
                        statChangedAlert.setChangedAmount(-statDrainAlert.getDrainAmount());
                        statChangedAlert.getNotifications().addAll(statDrainAlert.getNotifications());
                        return statChangedAlert;
                    }
                    return alert;
                });
                log.debug("Need to convert all Sound and TTS gain back to 0,10 scale.");
                this.alerts.stream().flatMap(alert -> alert.getNotifications().stream()).filter(notification -> notification instanceof IAudioNotification).map(notification -> (IAudioNotification)((Object)notification)).forEach(sound -> sound.setGain(Util.scale(sound.getGain(), -25.0f, 5.0f, 0.0f, 10.0f)));
            }
            if (configVersion.compareTo(new Version("2.8.0")) < 0) {
                log.debug("Need to convert flash notifications to new properties");
                this.alerts.stream().flatMap(alert -> alert.getNotifications().stream()).filter(notification -> notification instanceof ScreenFlash).map(notification -> (ScreenFlash)notification).forEach(screenFlash -> {
                    FlashNotification oldEnum = screenFlash.getFlashNotification();
                    screenFlash.setFlashMode(oldEnum == FlashNotification.SOLID_TWO_SECONDS || oldEnum == FlashNotification.SOLID_UNTIL_CANCELLED ? FlashMode.SOLID : FlashMode.FLASH);
                    screenFlash.setFlashDuration(oldEnum == FlashNotification.FLASH_TWO_SECONDS || oldEnum == FlashNotification.SOLID_TWO_SECONDS ? 2 : 0);
                    screenFlash.setFlashNotification(null);
                });
            }
            if (configVersion.compareTo(new Version("2.13.0")) < 0) {
                log.debug("Need to set default overlay notification text color");
                this.alerts.stream().flatMap(alert -> alert.getNotifications().stream()).filter(notification -> notification instanceof Overlay).map(notification -> (Overlay)notification).forEach(overlay -> {
                    if (overlay.getTextColor() == null) {
                        overlay.setTextColor(WatchdogConfig.DEFAULT_NOTIFICATION_TEXT_COLOR);
                    }
                });
            }
            this.configManager.setConfiguration("watchdog", "pluginVersion", currentVersion.getVersion());
            this.saveAlerts();
        }
    }

    public Gson getGson() {
        return this.gson;
    }

    public List<Alert> getAlerts() {
        return this.alerts;
    }

    public WatchdogPanel getWatchdogPanel() {
        return this.watchdogPanel;
    }
}

