/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.format;

import java.io.Serializable;

public class FormatKey<T>
implements Serializable,
Comparable {
    public static final FormatKey<MediaType> MediaTypeKey = new FormatKey<MediaType>("mediaType", MediaType.class);
    public static final FormatKey<String> EncodingKey = new FormatKey<String>("encoding", String.class);
    public static final String MIME_AVI = "video/avi";
    public static final String MIME_QUICKTIME = "video/quicktime";
    public static final String MIME_JAVA = "Java";
    public static final FormatKey<String> MimeTypeKey = new FormatKey<String>("mimeType", String.class);
    public static final FormatKey<Integer> FrameRateKey = new FormatKey<Integer>("frameRate", Integer.class);
    public static final FormatKey<Integer> KeyFrameIntervalKey = new FormatKey<Integer>("keyFrameInterval", Integer.class);
    public static final long serialVersionUID = 1L;
    private String key;
    private String name;
    private Class<T> clazz;
    private boolean comment;

    public FormatKey(String key, Class<T> clazz) {
        this(key, key, clazz);
    }

    public FormatKey(String key, String name, Class<T> clazz) {
        this(key, name, clazz, false);
    }

    public FormatKey(String key, String name, Class<T> clazz, boolean comment) {
        this.key = key;
        this.name = name;
        this.clazz = clazz;
        this.comment = comment;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.key;
    }

    public boolean isAssignable(Object value) {
        return this.clazz.isInstance(value);
    }

    public boolean isComment() {
        return this.comment;
    }

    public Class getValueClass() {
        return this.clazz;
    }

    public int compareTo(Object o) {
        return this.compareTo((FormatKey)o);
    }

    public int compareTo(FormatKey that) {
        return this.key.compareTo(that.key);
    }

    public static enum MediaType {
        AUDIO,
        VIDEO,
        FILE;

    }
}

