/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.codec;

import com.videorecorder.video.codec.AbstractVideoCodecCore;
import com.videorecorder.video.io.ByteArrayImageOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class TechSmithCodecCore
extends AbstractVideoCodecCore {
    private ByteArrayImageOutputStream temp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
    private int[] palette;

    public TechSmithCodecCore() {
        this.reset();
    }

    public void reset() {
        this.palette = null;
    }

    public void encodeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride, int compressionLevel) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.temp.write(0);
                this.temp.write(2);
                this.temp.write(Math.min(255, skipCount));
                this.temp.write(Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                byte v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.temp.write(1);
                            this.temp.write(data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.temp.write(0);
                        this.temp.write(literalRun);
                        this.temp.write(data, xy - literalCount, literalRun);
                        if ((literalRun & 1) == 1) {
                            this.temp.write(0);
                        }
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.temp.write(0);
                            this.temp.write(2);
                            this.temp.write(Math.min(255, skipCount));
                            this.temp.write(0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.temp.write(repeatCount);
                        this.temp.write(v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.temp.write(1);
                    this.temp.write(data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.temp.write(0);
                this.temp.write(literalRun);
                this.temp.write(data, xy - literalCount, literalRun);
                if ((literalRun & 1) == 1) {
                    this.temp.write(0);
                }
                literalCount -= literalRun;
            }
            this.temp.write(0);
            this.temp.write(0);
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            DeflaterOutputStream defl = new DeflaterOutputStream(out, new Deflater(compressionLevel));
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void encodeSameDelta8(OutputStream out) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeSameDelta24(OutputStream out) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeSameDelta16(OutputStream out) throws IOException {
        out.write(0);
        out.write(1);
    }

    public void encodeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride, int compressionLevel) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                byte v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.write(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.temp.write(1);
                            this.temp.write(data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.temp.write(data, xy - literalCount, literalCount);
                        if ((literalCount & 1) == 1) {
                            this.temp.write(0);
                        }
                        literalCount = 0;
                    }
                }
                this.temp.write(repeatCount);
                this.temp.write(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.temp.write(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.write(data, xy - literalCount, literalCount);
                    if ((literalCount & 1) == 1) {
                        this.temp.write(0);
                    }
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out, new Deflater(compressionLevel));
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    public void encodeDelta16(OutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride, int compressionLevel) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.temp.write(0);
                this.temp.write(2);
                this.temp.write(Math.min(255, skipCount));
                this.temp.write(Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                short v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.temp.write(1);
                            this.temp.writeShort(data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.temp.write(0);
                        this.temp.write(literalRun);
                        this.temp.writeShorts(data, xy - literalCount, literalRun);
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.temp.write(0);
                            this.temp.write(2);
                            this.temp.write(Math.min(255, skipCount));
                            this.temp.write(0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.temp.write(repeatCount);
                        this.temp.writeShort(v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.temp.write(1);
                    this.temp.writeShort(data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.temp.write(0);
                this.temp.write(literalRun);
                this.temp.writeShorts(data, xy - literalCount, literalRun);
                literalCount -= literalRun;
            }
            this.temp.write(0);
            this.temp.write(0);
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            DeflaterOutputStream defl = new DeflaterOutputStream(out, new Deflater(compressionLevel));
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void encodeKey24(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride, int compressionLevel) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                int v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.writeInts24LE(this.temp, data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.temp.write(1);
                            this.writeInt24LE(this.temp, data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.writeInts24LE(this.temp, data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                }
                this.temp.write(repeatCount);
                this.writeInt24LE(this.temp, v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.writeInt24LE(this.temp, data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.writeInts24LE(this.temp, data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out, new Deflater(compressionLevel));
        this.temp.toOutputStream(defl);
        defl.finish();
    }

    public void encodeDelta24(OutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride, int compressionLevel) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int verticalOffset = 0;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int skipCount = 0;
            while (xy < xymax && data[xy] == prev[xy]) {
                ++xy;
                ++skipCount;
            }
            if (skipCount == width) {
                ++verticalOffset;
                continue;
            }
            while (verticalOffset > 0 || skipCount > 0) {
                this.temp.write(0);
                this.temp.write(2);
                this.temp.write(Math.min(255, skipCount));
                this.temp.write(Math.min(255, verticalOffset));
                skipCount -= Math.min(255, skipCount);
                verticalOffset -= Math.min(255, verticalOffset);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                skipCount = 0;
                while (xy < xymax && data[xy] == prev[xy]) {
                    ++xy;
                    ++skipCount;
                }
                int v = data[xy -= skipCount];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                if (skipCount < 4 && (xy -= repeatCount) + skipCount < xymax && repeatCount < 3) {
                    ++literalCount;
                } else {
                    while (literalCount > 0) {
                        if (literalCount < 3) {
                            this.temp.write(1);
                            this.writeInt24LE(this.temp, data[xy - literalCount]);
                            --literalCount;
                            continue;
                        }
                        int literalRun = Math.min(254, literalCount);
                        this.temp.write(0);
                        this.temp.write(literalRun);
                        this.writeInts24LE(this.temp, data, xy - literalCount, literalRun);
                        literalCount -= literalRun;
                    }
                    if (xy + skipCount == xymax) {
                        xy += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 0) {
                            this.temp.write(0);
                            this.temp.write(2);
                            this.temp.write(Math.min(255, skipCount));
                            this.temp.write(0);
                            xy += Math.min(255, skipCount);
                            skipCount -= Math.min(255, skipCount);
                        }
                        --xy;
                    } else {
                        this.temp.write(repeatCount);
                        this.writeInt24LE(this.temp, v);
                        xy += repeatCount - 1;
                    }
                }
                ++xy;
            }
            while (literalCount > 0) {
                if (literalCount < 3) {
                    this.temp.write(1);
                    this.writeInt24LE(this.temp, data[xy - literalCount]);
                    --literalCount;
                    continue;
                }
                int literalRun = Math.min(254, literalCount);
                this.temp.write(0);
                this.temp.write(literalRun);
                this.writeInts24LE(this.temp, data, xy - literalCount, literalRun);
                literalCount -= literalRun;
            }
            this.temp.write(0);
            this.temp.write(0);
        }
        this.temp.write(0);
        this.temp.write(1);
        if (this.temp.length() == 2L) {
            this.temp.toOutputStream(out);
        } else {
            DeflaterOutputStream defl = new DeflaterOutputStream(out, new Deflater(compressionLevel));
            this.temp.toOutputStream(defl);
            defl.finish();
        }
    }

    public void encodeKey16(OutputStream out, short[] data, int width, int height, int offset, int scanlineStride, int compressionLevel) throws IOException {
        this.temp.clear();
        this.temp.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = upsideDown - y; xy < xymax; ++xy) {
                short v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 255 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount != 254) continue;
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.writeShorts(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    if (literalCount < 3) {
                        while (literalCount > 0) {
                            this.temp.write(1);
                            this.temp.writeShort(data[xy - literalCount]);
                            --literalCount;
                        }
                    } else {
                        this.temp.write(0);
                        this.temp.write(literalCount);
                        this.temp.writeShorts(data, xy - literalCount, literalCount);
                        literalCount = 0;
                    }
                }
                this.temp.write(repeatCount);
                this.temp.writeShort(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        this.temp.write(1);
                        this.temp.writeShort(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    this.temp.write(0);
                    this.temp.write(literalCount);
                    this.temp.writeShorts(data, xy - literalCount, literalCount);
                }
                literalCount = 0;
            }
            this.temp.write(0);
            this.temp.write(0);
        }
        this.temp.write(0);
        this.temp.write(1);
        DeflaterOutputStream defl = new DeflaterOutputStream(out, new Deflater(compressionLevel));
        this.temp.toOutputStream(defl);
        defl.finish();
    }
}

