/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.codec;

import com.videorecorder.video.codec.AbstractVideoCodec;
import com.videorecorder.video.codec.TechSmithCodecCore;
import com.videorecorder.video.format.Format;
import com.videorecorder.video.format.FormatKey;
import com.videorecorder.video.format.VideoFormatKeys;
import com.videorecorder.video.io.SeekableByteArrayOutputStream;
import com.videorecorder.video.nio.Buffer;
import com.videorecorder.video.nio.BufferFlag;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class TechSmithCodec
extends AbstractVideoCodec {
    public static final Integer DEFAULT_COMPRESSION_LEVEL = 6;
    private TechSmithCodecCore state;
    private Object previousPixels;
    private int frameCounter;

    public TechSmithCodec() {
        super(new Format[]{new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/avi", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/avi", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/avi", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/quicktime", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/quicktime", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/quicktime", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24})});
        this.name = "TechSmith Screen Capture";
    }

    @Override
    public void reset() {
        this.state = null;
        this.frameCounter = 0;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if (this.state == null) {
            this.state = new TechSmithCodecCore();
        }
        if (in.isFlag(BufferFlag.DISCARD)) {
            out.setMetaTo(in);
            return 0;
        }
        if (this.outputFormat.get(FormatKey.EncodingKey).equals("tscc")) {
            return this.encode(in, out);
        }
        return 0;
    }

    public int encode(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        boolean isKeyframe = this.frameCounter == 0 || this.frameCounter % this.outputFormat.get(FormatKey.KeyFrameIntervalKey, this.outputFormat.get(FormatKey.FrameRateKey)) == 0;
        out.setFlag(BufferFlag.KEYFRAME, isKeyframe);
        out.clearFlag(BufferFlag.SAME_DATA);
        ++this.frameCounter;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
            out.header = image.getColorModel();
        } else {
            r = new Rectangle(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey));
            scanlineStride = this.outputFormat.get(VideoFormatKeys.WidthKey);
            out.header = null;
        }
        int offset = r.x + r.y * scanlineStride;
        try {
            switch (this.outputFormat.get(VideoFormatKeys.DepthKey)) {
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey8(tmp, (byte[])pixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride, this.outputFormat.get(VideoFormatKeys.CompressionLevelKey, DEFAULT_COMPRESSION_LEVEL));
                    } else {
                        if (in.isFlag(BufferFlag.SAME_DATA)) {
                            this.state.encodeSameDelta8(tmp);
                        } else {
                            this.state.encodeDelta8(tmp, (byte[])pixels, (byte[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride, this.outputFormat.get(VideoFormatKeys.CompressionLevelKey, DEFAULT_COMPRESSION_LEVEL));
                        }
                        out.clearFlag(BufferFlag.KEYFRAME);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (byte[])this.previousPixels, 0, pixels.length);
                    break;
                }
                case 16: {
                    Object[] pixels = this.getRGB15(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey16(tmp, (short[])pixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride, this.outputFormat.get(VideoFormatKeys.CompressionLevelKey, DEFAULT_COMPRESSION_LEVEL));
                    } else if (in.isFlag(BufferFlag.SAME_DATA)) {
                        this.state.encodeSameDelta16(tmp);
                    } else {
                        this.state.encodeDelta16(tmp, (short[])pixels, (short[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride, this.outputFormat.get(VideoFormatKeys.CompressionLevelKey, DEFAULT_COMPRESSION_LEVEL));
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (short[])this.previousPixels, 0, pixels.length);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    if (isKeyframe) {
                        this.state.encodeKey24(tmp, (int[])pixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride, this.outputFormat.get(VideoFormatKeys.CompressionLevelKey, DEFAULT_COMPRESSION_LEVEL));
                        out.setFlag(BufferFlag.KEYFRAME);
                    } else {
                        if (in.isFlag(BufferFlag.SAME_DATA)) {
                            this.state.encodeSameDelta24(tmp);
                        } else {
                            this.state.encodeDelta24(tmp, (int[])pixels, (int[])this.previousPixels, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), offset, scanlineStride, this.outputFormat.get(VideoFormatKeys.CompressionLevelKey, DEFAULT_COMPRESSION_LEVEL));
                        }
                        out.clearFlag(BufferFlag.KEYFRAME);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, (int[])this.previousPixels, 0, pixels.length);
                    break;
                }
                default: {
                    out.setFlag(BufferFlag.DISCARD);
                    return 1;
                }
            }
            out.format = this.outputFormat;
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.sampleCount = 1;
            out.length = tmp.size();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 0;
        }
    }
}

