/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.codec;

import com.videorecorder.video.avi.AVIWriter;
import com.videorecorder.video.codec.Codec;
import com.videorecorder.video.codec.TechSmithCodec;
import com.videorecorder.video.format.Format;
import com.videorecorder.video.format.FormatKey;
import com.videorecorder.video.format.VideoFormatKeys;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Registry {
    private HashMap<String, LinkedList<RegistryEntry>> codecMap;
    private HashMap<String, LinkedList<RegistryEntry>> writerMap;
    private static Registry instance;

    public static Registry getInstance() {
        if (instance == null) {
            instance = new Registry();
            instance.init();
        }
        return instance;
    }

    protected void init() {
        this.codecMap = new HashMap();
        this.writerMap = new HashMap();
        this.putBidiCodec(new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/avi", FormatKey.EncodingKey, "tscc"}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "Java", FormatKey.EncodingKey, "image"}), TechSmithCodec.class.getName());
        this.putBidiCodec(new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/quicktime", FormatKey.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "TechSmith Screen Capture"}), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "Java", FormatKey.EncodingKey, "image"}), TechSmithCodec.class.getName());
        this.putWriter(new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.FILE, FormatKey.MimeTypeKey, "video/avi"}), AVIWriter.class.getName());
    }

    public void putBidiCodec(Format inputFormat, Format outputFormat, String codecClass) {
        this.putCodec(inputFormat, outputFormat, codecClass);
        this.putCodec(outputFormat, inputFormat, codecClass);
    }

    public void putCodec(Format inputFormat, Format outputFormat, String codecClass) {
        RegistryEntry entry = new RegistryEntry(inputFormat, outputFormat, codecClass);
        this.addCodecEntry(inputFormat.get(FormatKey.EncodingKey), entry);
        this.addCodecEntry(outputFormat.get(FormatKey.EncodingKey), entry);
    }

    private void addCodecEntry(String key, RegistryEntry entry) {
        LinkedList<RegistryEntry> list = this.codecMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.codecMap.put(key, list);
        }
        list.add(entry);
    }

    public String[] getCodecClasses(Format inputFormat, Format outputFormat) {
        LinkedList<Object> re;
        HashSet<String> classNames = new HashSet<String>();
        HashSet<Object> entries = new HashSet<Object>();
        if (inputFormat != null) {
            if (inputFormat.get(FormatKey.EncodingKey) == null) {
                re = new LinkedList();
                for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
                    for (RegistryEntry j : i.getValue()) {
                        if (!inputFormat.matches(j.inputFormat)) continue;
                        re.add(j);
                    }
                }
            } else {
                re = this.codecMap.get(inputFormat.get(FormatKey.EncodingKey));
            }
            if (re != null) {
                entries.addAll(re);
            }
        }
        if (outputFormat != null) {
            if (outputFormat.get(FormatKey.EncodingKey) == null) {
                re = new LinkedList();
                for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
                    for (RegistryEntry j : i.getValue()) {
                        if (!outputFormat.matches(j.outputFormat)) continue;
                        re.add(j);
                    }
                }
            } else {
                re = this.codecMap.get(outputFormat.get(FormatKey.EncodingKey));
            }
            if (re != null) {
                entries.addAll(re);
            }
        }
        for (RegistryEntry registryEntry : entries) {
            if (inputFormat != null && registryEntry.inputFormat != null && !inputFormat.matches(registryEntry.inputFormat) || outputFormat != null && registryEntry.outputFormat != null && !outputFormat.matches(registryEntry.outputFormat)) continue;
            classNames.add(registryEntry.className);
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    public Codec getEncoder(Format outputFormat) {
        return this.getCodec(null, outputFormat);
    }

    public Codec getCodec(Format inputFormat, Format outputFormat) {
        String[] clazz = this.getCodecClasses(inputFormat, outputFormat);
        for (int i = 0; i < clazz.length; ++i) {
            try {
                Codec codec = (Codec)Class.forName(clazz[i]).newInstance();
                codec.setInputFormat(inputFormat);
                if (outputFormat != null) {
                    codec.setOutputFormat(outputFormat);
                }
                return codec;
            }
            catch (Exception ex) {
                System.err.println("Monte Registry. Codec class not found: " + clazz[i]);
                this.unregisterCodec(clazz[i]);
                continue;
            }
        }
        return null;
    }

    public void putWriter(Format fileFormat, String writerClass) {
        RegistryEntry entry = new RegistryEntry(fileFormat, null, writerClass);
        String key = fileFormat.get(FormatKey.MimeTypeKey);
        LinkedList<RegistryEntry> list = this.writerMap.get(key);
        if (list == null) {
            list = new LinkedList();
            this.writerMap.put(key, list);
        }
        list.add(entry);
    }

    public void unregisterCodec(String codecClass) {
        for (Map.Entry<String, LinkedList<RegistryEntry>> i : this.codecMap.entrySet()) {
            LinkedList<RegistryEntry> ll = i.getValue();
            Iterator j = ll.iterator();
            while (j.hasNext()) {
                RegistryEntry e = (RegistryEntry)j.next();
                if (!e.className.equals(codecClass)) continue;
                j.remove();
            }
        }
    }

    private static class RegistryEntry {
        Format inputFormat;
        Format outputFormat;
        String className;

        public RegistryEntry(Format inputFormat, Format outputFormat, String className) {
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.className = className;
        }
    }
}

