/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.codec;

import com.videorecorder.video.codec.AbstractCodec;
import com.videorecorder.video.format.Format;
import com.videorecorder.video.format.VideoFormatKeys;
import com.videorecorder.video.nio.Buffer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;

public abstract class AbstractVideoCodec
extends AbstractCodec {
    private BufferedImage imgConverter;

    public AbstractVideoCodec(Format[] supportedInputFormats) {
        super(supportedInputFormats);
    }

    protected byte[] getIndexed8(Buffer buf) {
        BufferedImage image;
        if (buf.data instanceof byte[]) {
            return (byte[])buf.data;
        }
        if (buf.data instanceof BufferedImage && (image = (BufferedImage)buf.data).getRaster().getDataBuffer() instanceof DataBufferByte) {
            return ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        }
        return null;
    }

    protected short[] getRGB15(Buffer buf) {
        if (buf.data instanceof int[]) {
            return (short[])buf.data;
        }
        if (buf.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)buf.data;
            if (image.getColorModel() instanceof DirectColorModel) {
                DirectColorModel dcm = (DirectColorModel)image.getColorModel();
                if (image.getRaster().getDataBuffer() instanceof DataBufferShort) {
                    return ((DataBufferShort)image.getRaster().getDataBuffer()).getData();
                }
                if (image.getRaster().getDataBuffer() instanceof DataBufferUShort) {
                    return ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                }
            }
            if (this.imgConverter == null) {
                int width = this.outputFormat.get(VideoFormatKeys.WidthKey);
                int height = this.outputFormat.get(VideoFormatKeys.HeightKey);
                this.imgConverter = new BufferedImage(width, height, 9);
            }
            Graphics2D g = this.imgConverter.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            return ((DataBufferUShort)this.imgConverter.getRaster().getDataBuffer()).getData();
        }
        return null;
    }

    protected int[] getRGB24(Buffer buf) {
        if (buf.data instanceof int[]) {
            return (int[])buf.data;
        }
        if (buf.data instanceof BufferedImage) {
            DirectColorModel dcm;
            BufferedImage image = (BufferedImage)buf.data;
            if (image.getColorModel() instanceof DirectColorModel && (dcm = (DirectColorModel)image.getColorModel()).getBlueMask() == 255 && dcm.getGreenMask() == 65280 && dcm.getRedMask() == 0xFF0000 && image.getRaster().getDataBuffer() instanceof DataBufferInt) {
                return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            }
            return image.getRGB(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), null, 0, this.outputFormat.get(VideoFormatKeys.WidthKey));
        }
        return null;
    }

    protected int[] getARGB32(Buffer buf) {
        if (buf.data instanceof int[]) {
            return (int[])buf.data;
        }
        if (buf.data instanceof BufferedImage) {
            DirectColorModel dcm;
            BufferedImage image = (BufferedImage)buf.data;
            if (image.getColorModel() instanceof DirectColorModel && (dcm = (DirectColorModel)image.getColorModel()).getBlueMask() == 255 && dcm.getGreenMask() == 65280 && dcm.getRedMask() == 0xFF0000 && image.getRaster().getDataBuffer() instanceof DataBufferInt) {
                return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            }
            return image.getRGB(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), null, 0, this.outputFormat.get(VideoFormatKeys.WidthKey));
        }
        return null;
    }
}

