/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.codec;

import com.videorecorder.video.codec.Codec;
import com.videorecorder.video.format.Format;
import java.util.ArrayList;

public abstract class AbstractCodec
implements Codec {
    protected Format[] inputFormats;
    protected Format[] outputFormats;
    protected Format inputFormat;
    protected Format outputFormat;
    protected String name = "unnamed codec";

    public AbstractCodec(Format[] supportedInputOutputFormats) {
        this.inputFormats = supportedInputOutputFormats;
        this.outputFormats = supportedInputOutputFormats;
    }

    @Override
    public Format[] getInputFormats() {
        return (Format[])this.inputFormats.clone();
    }

    @Override
    public Format[] getOutputFormats(Format input) {
        ArrayList<Format> of = new ArrayList<Format>(this.outputFormats.length);
        for (Format f : this.outputFormats) {
            of.add(input == null ? f : f.append(input));
        }
        return of.toArray(new Format[of.size()]);
    }

    @Override
    public Format setInputFormat(Format f) {
        if (f != null) {
            for (Format sf : this.getInputFormats()) {
                if (!sf.matches(f)) continue;
                this.inputFormat = sf.append(f);
                return this.inputFormat;
            }
        }
        this.inputFormat = null;
        return null;
    }

    @Override
    public Format setOutputFormat(Format f) {
        for (Format sf : this.getOutputFormats(f)) {
            if (!sf.matches(f)) continue;
            this.outputFormat = f;
            return sf;
        }
        this.outputFormat = null;
        return null;
    }

    @Override
    public Format getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public Format getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return className.substring(p + 1) + "{inputFormat = " + this.inputFormat + ", outputFormat = " + this.outputFormat + "}";
    }
}

