/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder.video.avi;

import com.videorecorder.video.codec.Codec;
import com.videorecorder.video.codec.Registry;
import com.videorecorder.video.codec.TechSmithCodec;
import com.videorecorder.video.format.Format;
import com.videorecorder.video.format.FormatKey;
import com.videorecorder.video.format.VideoFormatKeys;
import com.videorecorder.video.io.ByteArrayImageOutputStream;
import com.videorecorder.video.nio.Buffer;
import com.videorecorder.video.nio.BufferFlag;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

public class AVIWriter {
    protected static final int RIFF_ID = 1380533830;
    protected static final int AVI_ID = 1096173856;
    protected static final int LIST_ID = 1279873876;
    protected static final int MOVI_ID = 1836021353;
    protected static final int HDRL_ID = 1751413356;
    protected static final int AVIH_ID = 1635150184;
    protected static final int STRL_ID = 1937011308;
    protected static final int STRH_ID = 1937011304;
    protected static final int STRN_ID = 1937011310;
    protected static final int STRF_ID = 1937011302;
    protected static final int IDX1_ID = 1768192049;
    protected static final int PC_ID = 28771;
    protected static final int DB_ID = 25698;
    protected static final int DC_ID = 25699;
    public static final int STRH_FLAG_VIDEO_PALETTE_CHANGES = 65536;
    protected ImageOutputStream out;
    protected long streamOffset;
    protected States state = States.FINISHED;
    protected CompositeChunk aviChunk;
    protected CompositeChunk moviChunk;
    protected FixedSizeDataChunk avihChunk;
    ArrayList<Sample> idx1 = new ArrayList();
    protected ArrayList<VideoTrack> tracks = new ArrayList();

    public AVIWriter(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.out = new FileImageOutputStream(file);
        this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.streamOffset = 0L;
    }

    public int addVideoTrack(Format vf) throws IOException {
        if (!vf.containsKey(FormatKey.EncodingKey)) {
            throw new IllegalArgumentException("EncodingKey missing in " + vf);
        }
        if (!vf.containsKey(FormatKey.FrameRateKey)) {
            throw new IllegalArgumentException("FrameRateKey missing in " + vf);
        }
        if (!vf.containsKey(VideoFormatKeys.WidthKey)) {
            throw new IllegalArgumentException("WidthKey missing in " + vf);
        }
        if (!vf.containsKey(VideoFormatKeys.HeightKey)) {
            throw new IllegalArgumentException("HeightKey missing in " + vf);
        }
        if (!vf.containsKey(VideoFormatKeys.DepthKey)) {
            throw new IllegalArgumentException("DepthKey missing in " + vf);
        }
        int tr = this.addVideoTrack(vf.get(FormatKey.EncodingKey), 1, vf.get(FormatKey.FrameRateKey), vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey), vf.get(VideoFormatKeys.DepthKey), vf.get(FormatKey.KeyFrameIntervalKey, vf.get(FormatKey.FrameRateKey)), vf.get(VideoFormatKeys.CompressionLevelKey, TechSmithCodec.DEFAULT_COMPRESSION_LEVEL));
        this.setCompressionQuality(tr, vf.get(VideoFormatKeys.QualityKey, Float.valueOf(1.0f)).floatValue());
        return tr;
    }

    public int addVideoTrack(String fccHandler, int scale, int rate, int width, int height, int depth, int syncInterval, int compressionLevel) throws IOException {
        this.ensureFinished();
        if (fccHandler == null || fccHandler.length() != 4) {
            throw new IllegalArgumentException("fccHandler must be 4 characters long:" + fccHandler);
        }
        VideoTrack vt = new VideoTrack(this.tracks.size(), AVIWriter.typeToInt(fccHandler), new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.MimeTypeKey, "video/avi", FormatKey.EncodingKey, fccHandler, VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, depth, VideoFormatKeys.FixedFrameRateKey, true, FormatKey.FrameRateKey, rate, FormatKey.KeyFrameIntervalKey, syncInterval, VideoFormatKeys.CompressionLevelKey, compressionLevel}));
        vt.scale = scale;
        vt.rate = rate;
        vt.syncInterval = syncInterval;
        vt.frameLeft = 0;
        vt.frameTop = 0;
        vt.frameRight = width;
        vt.frameBottom = height;
        vt.bitCount = depth;
        vt.planes = 1;
        if (depth == 4) {
            byte[] gray = new byte[16];
            for (int i = 0; i < gray.length; ++i) {
                gray[i] = (byte)(i << 4 | i);
            }
            vt.palette = new IndexColorModel(4, 16, gray, gray, gray);
        } else if (depth == 8) {
            byte[] gray = new byte[256];
            for (int i = 0; i < gray.length; ++i) {
                gray[i] = (byte)i;
            }
            vt.palette = new IndexColorModel(8, 256, gray, gray, gray);
        }
        this.tracks.add(vt);
        return this.tracks.size() - 1;
    }

    public void write(int track, BufferedImage image) throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.ensureStarted();
        VideoTrack vt = this.tracks.get(track);
        if (vt.codec == null) {
            this.createCodec(track);
        }
        if (vt.codec == null) {
            throw new UnsupportedOperationException("No codec for this format: " + vt.format);
        }
        Format fmt = vt.format;
        if (fmt.get(VideoFormatKeys.WidthKey).intValue() != image.getWidth() || fmt.get(VideoFormatKeys.HeightKey).intValue() != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of image[" + vt.samples.size() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video format of track: " + fmt);
        }
        if (vt.outputBuffer == null) {
            vt.outputBuffer = new Buffer();
        }
        boolean isKeyframe = vt.syncInterval == 0 ? false : vt.samples.size() % vt.syncInterval == 0;
        Buffer inputBuffer = new Buffer();
        inputBuffer.flags = isKeyframe ? EnumSet.of(BufferFlag.KEYFRAME) : EnumSet.noneOf(BufferFlag.class);
        inputBuffer.data = image;
        vt.codec.process(inputBuffer, vt.outputBuffer);
        if (vt.outputBuffer.flags.contains((Object)BufferFlag.DISCARD)) {
            return;
        }
        isKeyframe = vt.outputBuffer.flags.contains((Object)BufferFlag.KEYFRAME);
        boolean paletteChange = this.writePalette(track, image, isKeyframe);
        this.writeSample(track, (byte[])vt.outputBuffer.data, vt.outputBuffer.offset, vt.outputBuffer.length, isKeyframe && !paletteChange);
    }

    private boolean writePalette(int track, BufferedImage image, boolean isKeyframe) throws IOException {
        if (image.getColorModel() instanceof IndexColorModel) {
            return this.writePalette(track, (IndexColorModel)image.getColorModel(), isKeyframe);
        }
        return false;
    }

    private boolean writePalette(int track, IndexColorModel imgPalette, boolean isKeyframe) throws IOException {
        this.ensureStarted();
        VideoTrack vt = this.tracks.get(track);
        int imgDepth = vt.bitCount;
        ByteArrayImageOutputStream tmp = null;
        boolean paletteChange = false;
        switch (imgDepth) {
            case 4: {
                int[] imgRGBs = new int[16];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[16];
                if (vt.previousPalette == null) {
                    vt.previousPalette = vt.palette;
                }
                vt.previousPalette.getRGBs(previousRGBs);
                if (!isKeyframe && Arrays.equals(imgRGBs, previousRGBs)) break;
                paletteChange = true;
                vt.previousPalette = imgPalette;
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                tmp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
                tmp.writeByte(first);
                tmp.writeByte(last - first + 1);
                tmp.writeShort(0);
                for (int i = first; i <= last; ++i) {
                    tmp.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    tmp.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    tmp.writeByte(imgRGBs[i] & 0xFF);
                    tmp.writeByte(0);
                }
                break;
            }
            case 8: {
                int[] imgRGBs = new int[256];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[256];
                if (vt.previousPalette != null) {
                    vt.previousPalette.getRGBs(previousRGBs);
                }
                if (!isKeyframe && Arrays.equals(imgRGBs, previousRGBs)) break;
                paletteChange = true;
                vt.previousPalette = imgPalette;
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                tmp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
                tmp.writeByte(first);
                tmp.writeByte(last - first + 1);
                tmp.writeShort(0);
                for (int i = first; i <= last; ++i) {
                    tmp.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    tmp.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    tmp.writeByte(imgRGBs[i] & 0xFF);
                    tmp.writeByte(0);
                }
                break;
            }
        }
        if (tmp != null) {
            tmp.close();
            this.writePalette(track, tmp.toByteArray(), 0, (int)tmp.length(), isKeyframe);
        }
        return paletteChange;
    }

    public void setPalette(int track, ColorModel palette) {
        if (palette instanceof IndexColorModel) {
            this.tracks.get((int)track).palette = (IndexColorModel)palette;
        }
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getEncoder(fmt.prepend(FormatKey.MimeTypeKey, "video/avi"));
    }

    private void createCodec(int track) {
        VideoTrack tr = this.tracks.get(track);
        Format fmt = tr.format;
        tr.codec = this.createCodec(fmt);
        if (tr.codec != null) {
            if (fmt.get(FormatKey.MediaTypeKey) == FormatKey.MediaType.VIDEO) {
                tr.codec.setInputFormat(fmt.prepend(FormatKey.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class));
                if (null == tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.QualityKey, Float.valueOf(this.getCompressionQuality(track)), FormatKey.MimeTypeKey, "video/avi", VideoFormatKeys.DataClassKey, byte[].class))) {
                    throw new UnsupportedOperationException("Track " + tr + " codec does not support format " + fmt + ". codec=" + tr.codec);
                }
            } else {
                tr.codec.setInputFormat(null);
                if (null == tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.QualityKey, Float.valueOf(this.getCompressionQuality(track)), FormatKey.MimeTypeKey, "video/avi", VideoFormatKeys.DataClassKey, byte[].class))) {
                    throw new UnsupportedOperationException("Track " + tr + " codec " + tr.codec + " does not support format. " + fmt);
                }
            }
        }
    }

    public Dimension getVideoDimension(int track) {
        VideoTrack vt = this.tracks.get(track);
        Format fmt = vt.format;
        return new Dimension(fmt.get(VideoFormatKeys.WidthKey), fmt.get(VideoFormatKeys.HeightKey));
    }

    public void setCompressionQuality(int track, float newValue) {
        VideoTrack vt = this.tracks.get(track);
        vt.videoQuality = newValue;
    }

    public float getCompressionQuality(int track) {
        return this.tracks.get((int)track).videoQuality;
    }

    protected void ensureStarted() throws IOException {
        if (this.state != States.STARTED) {
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    protected void ensureFinished() {
        if (this.state != States.FINISHED) {
            throw new IllegalStateException("Writer is in illegal state for this operation.");
        }
    }

    public void writePalette(int track, byte[] data, int off, int len, boolean isKeyframe) throws IOException {
        VideoTrack vt = this.tracks.get(track);
        if (!isKeyframe && vt.samples.isEmpty()) {
            throw new IllegalStateException("The first sample in a track must be a keyframe.");
        }
        vt.flags |= 0x10000;
        DataChunk paletteChangeChunk = new DataChunk(vt.twoCC | 0x7063);
        long offset = this.getRelativeStreamPosition();
        ImageOutputStream pOut = paletteChangeChunk.getOutputStream();
        pOut.write(data, off, len);
        this.moviChunk.add(paletteChangeChunk);
        paletteChangeChunk.finish();
        long length = this.getRelativeStreamPosition() - offset;
        Sample s = new Sample(paletteChangeChunk.chunkType, 0, offset, length, isKeyframe);
        vt.addSample(s);
        this.idx1.add(s);
        offset = this.getRelativeStreamPosition();
    }

    public void writeSample(int track, byte[] data, int off, int len, boolean isKeyframe) throws IOException {
        this.ensureStarted();
        VideoTrack tr = this.tracks.get(track);
        if (!isKeyframe && tr.samples.isEmpty()) {
            throw new IllegalStateException("The first sample in a track must be a keyframe.\nTrack=" + track + ", " + tr.format);
        }
        if (isKeyframe && 0 != (tr.flags & 0x10000)) {
            throw new IllegalStateException("Only palette changes can be marked as keyframe.\nTrack=" + track + ", " + tr.format);
        }
        DataChunk dc = new DataChunk(tr.getSampleChunkFourCC(), len);
        this.moviChunk.add(dc);
        ImageOutputStream mdatOut = dc.getOutputStream();
        long offset = this.getRelativeStreamPosition();
        mdatOut.write(data, off, len);
        long length = this.getRelativeStreamPosition() - offset;
        dc.finish();
        Sample s = new Sample(dc.chunkType, 1, offset, length, isKeyframe);
        tr.addSample(s);
        this.idx1.add(s);
        if (this.getRelativeStreamPosition() > 0x100000000L) {
            throw new IOException("AVI file is larger than 4 GB");
        }
    }

    public boolean isClosed() {
        return this.state == States.CLOSED;
    }

    public void close() throws IOException {
        if (this.state == States.STARTED) {
            this.finish();
        }
        if (this.state != States.CLOSED) {
            this.out.close();
            this.state = States.CLOSED;
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            this.moviChunk.finish();
            this.writeEpilog();
            this.state = States.FINISHED;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private void writeProlog() throws IOException {
        this.aviChunk = new CompositeChunk(1380533830, 1096173856);
        CompositeChunk hdrlChunk = new CompositeChunk(1279873876, 1751413356);
        this.aviChunk.add(hdrlChunk);
        this.avihChunk = new FixedSizeDataChunk(1635150184, 56L);
        this.avihChunk.seekToEndOfChunk();
        hdrlChunk.add(this.avihChunk);
        for (VideoTrack tr : this.tracks) {
            CompositeChunk strlChunk = new CompositeChunk(1279873876, 1937011308);
            hdrlChunk.add(strlChunk);
            tr.strhChunk = new FixedSizeDataChunk(1937011304, 56L);
            tr.strhChunk.seekToEndOfChunk();
            strlChunk.add(tr.strhChunk);
            tr.strfChunk = new FixedSizeDataChunk(1937011302, tr.getSTRFChunkSize());
            tr.strfChunk.seekToEndOfChunk();
            strlChunk.add(tr.strfChunk);
            if (tr.name == null) continue;
            byte[] data = (tr.name + "\u0000").getBytes("ASCII");
            DataChunk d = new DataChunk(1937011310, data.length);
            ImageOutputStream dout = d.getOutputStream();
            dout.write(data);
            d.finish();
            strlChunk.add(d);
        }
        this.moviChunk = new CompositeChunk(1279873876, 1836021353);
        this.aviChunk.add(this.moviChunk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeEpilog() throws IOException {
        DataChunk idx1Chunk = new DataChunk(1768192049);
        this.aviChunk.add(idx1Chunk);
        ImageOutputStream d = idx1Chunk.getOutputStream();
        long moviListOffset = this.moviChunk.offset + 8L + 8L;
        for (Sample sample : this.idx1) {
            d.setByteOrder(ByteOrder.BIG_ENDIAN);
            d.writeInt(sample.chunkType);
            d.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            d.writeInt(((sample.chunkType & 0xFFFF) == 28771 ? 256 : 0) | (sample.isKeyframe ? 16 : 0));
            d.writeInt((int)(sample.offset - moviListOffset));
            d.writeInt((int)sample.length);
        }
        idx1Chunk.finish();
        this.avihChunk.seekToStartOfData();
        d = this.avihChunk.getOutputStream();
        long largestBufferSize = 0L;
        long duration = 0L;
        for (VideoTrack tr : this.tracks) {
            long trackDuration = 0L;
            for (Sample s : tr.samples) {
                trackDuration += (long)s.duration;
            }
            duration = Math.max(duration, trackDuration);
            for (Sample s : tr.samples) {
                if (s.length <= largestBufferSize) continue;
                largestBufferSize = s.length;
            }
        }
        VideoTrack videoTrack = this.tracks.get(0);
        d.writeInt((int)(1000000L * videoTrack.scale / videoTrack.rate));
        d.writeInt((int)largestBufferSize);
        d.writeInt(0);
        d.writeInt(2320);
        d.writeInt(videoTrack.samples.size());
        d.writeInt(0);
        d.writeInt(this.tracks.size());
        d.writeInt((int)largestBufferSize);
        int width = 0;
        int height = 0;
        for (VideoTrack tr : this.tracks) {
            width = Math.max(width, Math.max(tr.frameLeft, tr.frameRight));
            height = Math.max(height, Math.max(tr.frameTop, tr.frameBottom));
        }
        d.writeInt(width);
        d.writeInt(height);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        d.writeInt(0);
        for (VideoTrack vt : this.tracks) {
            vt.strhChunk.seekToStartOfData();
            d = vt.strhChunk.getOutputStream();
            d.setByteOrder(ByteOrder.BIG_ENDIAN);
            d.writeInt(AVIWriter.typeToInt("vids"));
            d.writeInt(vt.fccHandler);
            d.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            d.writeInt(vt.flags);
            d.writeShort(vt.priority);
            d.writeShort(vt.language);
            d.writeInt((int)vt.initialFrames);
            d.writeInt((int)vt.scale);
            d.writeInt((int)vt.rate);
            d.writeInt((int)vt.startTime);
            d.writeInt((int)vt.length);
            long dwSuggestedBufferSize = 0L;
            long l = -1L;
            for (Sample s : vt.samples) {
                if (s.length > dwSuggestedBufferSize) {
                    dwSuggestedBufferSize = s.length;
                }
                if (l == -1L) {
                    l = s.length;
                    continue;
                }
                if (l == s.length) continue;
                l = 0L;
            }
            if (l == -1L) {
                l = 0L;
            }
            d.writeInt((int)dwSuggestedBufferSize);
            d.writeInt(vt.quality);
            d.writeInt((int)l);
            d.writeShort(vt.frameLeft);
            d.writeShort(vt.frameTop);
            d.writeShort(vt.frameRight);
            d.writeShort(vt.frameBottom);
            Format vf = vt.format;
            vt.strfChunk.seekToStartOfData();
            d = vt.strfChunk.getOutputStream();
            d.writeInt(40);
            d.writeInt(vf.get(VideoFormatKeys.WidthKey));
            d.writeInt(vf.get(VideoFormatKeys.HeightKey));
            d.writeShort(1);
            d.writeShort(vf.get(VideoFormatKeys.DepthKey));
            String enc = vf.get(FormatKey.EncodingKey);
            if (enc.equals("DIB ")) {
                d.writeInt(0);
            } else if (enc.equals("RLE ")) {
                if (vf.get(VideoFormatKeys.DepthKey) == 8) {
                    d.writeInt(1);
                } else {
                    if (vf.get(VideoFormatKeys.DepthKey) != 4) throw new UnsupportedOperationException("RLE only supports 4-bit and 8-bit images");
                    d.writeInt(2);
                }
            } else {
                d.setByteOrder(ByteOrder.BIG_ENDIAN);
                d.writeInt(AVIWriter.typeToInt(vt.format.get(FormatKey.EncodingKey)));
                d.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            }
            if (enc.equals("DIB ")) {
                d.writeInt(0);
            } else if (vf.get(VideoFormatKeys.DepthKey) == 4) {
                d.writeInt(vf.get(VideoFormatKeys.WidthKey) * vf.get(VideoFormatKeys.HeightKey) / 2);
            } else {
                int bytesPerPixel = Math.max(1, vf.get(VideoFormatKeys.DepthKey) / 8);
                d.writeInt(vf.get(VideoFormatKeys.WidthKey) * vf.get(VideoFormatKeys.HeightKey) * bytesPerPixel);
            }
            d.writeInt(0);
            d.writeInt(0);
            d.writeInt(vt.palette == null ? 0 : vt.palette.getMapSize());
            d.writeInt(0);
            if (vt.palette == null) continue;
            int n = vt.palette.getMapSize();
            for (int i = 0; i < n; ++i) {
                d.write(vt.palette.getBlue(i));
                d.write(vt.palette.getGreen(i));
                d.write(vt.palette.getRed(i));
                d.write(0);
            }
        }
        this.aviChunk.finish();
    }

    protected long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    protected void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    protected static int typeToInt(String str) {
        return (str.charAt(0) & 0xFF) << 24 | (str.charAt(1) & 0xFF) << 16 | (str.charAt(2) & 0xFF) << 8 | str.charAt(3) & 0xFF;
    }

    protected class FixedSizeDataChunk
    extends Chunk {
        protected boolean finished;
        protected long fixedSize;

        public FixedSizeDataChunk(int chunkType, long fixedSize) throws IOException {
            super(chunkType);
            this.fixedSize = fixedSize;
            AVIWriter.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
            AVIWriter.this.out.writeInt(chunkType);
            AVIWriter.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            AVIWriter.this.out.writeInt((int)fixedSize);
            byte[] buf = new byte[(int)Math.min(512L, fixedSize)];
            for (long written = 0L; written < fixedSize; written += Math.min((long)buf.length, fixedSize - written)) {
                AVIWriter.this.out.write(buf, 0, (int)Math.min((long)buf.length, fixedSize - written));
            }
            if (fixedSize % 2L == 1L) {
                AVIWriter.this.out.writeByte(0);
            }
            this.seekToStartOfData();
        }

        public ImageOutputStream getOutputStream() {
            return AVIWriter.this.out;
        }

        public void seekToStartOfData() throws IOException {
            AVIWriter.this.seekRelative(this.offset + 8L);
        }

        public void seekToEndOfChunk() throws IOException {
            AVIWriter.this.seekRelative(this.offset + 8L + this.fixedSize + this.fixedSize % 2L);
        }

        @Override
        public void finish() {
            if (!this.finished) {
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 8L + this.fixedSize;
        }
    }

    protected class DataChunk
    extends Chunk {
        protected boolean finished;
        private long finishedSize;

        public DataChunk(int name) throws IOException {
            this(name, -1L);
        }

        public DataChunk(int name, long dataSize) throws IOException {
            super(name);
            AVIWriter.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
            AVIWriter.this.out.writeInt(this.chunkType);
            AVIWriter.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            AVIWriter.this.out.writeInt((int)Math.max(0L, dataSize));
            this.finishedSize = dataSize == -1L ? -1L : dataSize + 8L;
        }

        public ImageOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataChunk is finished");
            }
            return AVIWriter.this.out;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.finishedSize == -1L) {
                    this.finishedSize = this.size();
                    if (this.finishedSize > 0xFFFFFFFFL) {
                        throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + this.size());
                    }
                    AVIWriter.this.seekRelative(this.offset + 4L);
                    AVIWriter.this.out.writeInt((int)(this.finishedSize - 8L));
                    AVIWriter.this.seekRelative(this.offset + this.finishedSize);
                } else if (this.size() != this.finishedSize) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" actual size differs from given size: actual size:" + this.size() + " given size:" + this.finishedSize);
                }
                if (this.size() % 2L == 1L) {
                    AVIWriter.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            if (this.finished) {
                return this.finishedSize;
            }
            try {
                return AVIWriter.this.out.getStreamPosition() - this.offset;
            }
            catch (IOException ex) {
                InternalError ie = new InternalError("IOException");
                ie.initCause(ex);
                throw ie;
            }
        }
    }

    protected class CompositeChunk
    extends Chunk {
        protected int compositeType;
        protected LinkedList<Chunk> children;
        protected boolean finished;

        public CompositeChunk(int compositeType, int chunkType) throws IOException {
            super(chunkType);
            this.compositeType = compositeType;
            AVIWriter.this.out.writeLong(0L);
            AVIWriter.this.out.writeInt(0);
            this.children = new LinkedList();
        }

        public void add(Chunk child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AVIWriter.this.getRelativeStreamPosition();
                AVIWriter.this.seekRelative(this.offset);
                AVIWriter.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
                AVIWriter.this.out.writeInt(this.compositeType);
                AVIWriter.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                AVIWriter.this.out.writeInt((int)(this.size() - 8L));
                AVIWriter.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
                AVIWriter.this.out.writeInt(this.chunkType);
                AVIWriter.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                for (Chunk child : this.children) {
                    child.finish();
                }
                AVIWriter.this.seekRelative(pointer);
                if (this.size() % 2L == 1L) {
                    AVIWriter.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 12L;
            for (Chunk child : this.children) {
                length += child.size() + child.size() % 2L;
            }
            return length;
        }
    }

    protected abstract class Chunk {
        protected int chunkType;
        protected long offset;

        public Chunk(int chunkType) throws IOException {
            this.chunkType = chunkType;
            this.offset = AVIWriter.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    protected class VideoTrack {
        protected Format format;
        protected ArrayList<Sample> samples;
        protected int syncInterval = 30;
        protected int twoCC;
        protected static final String FOURCC = "vids";
        protected int fccHandler;
        protected int flags;
        protected int priority = 0;
        protected int language = 0;
        protected long initialFrames = 0L;
        protected long scale = 1L;
        protected long rate = 30L;
        protected long startTime = 0L;
        protected long length;
        protected int quality = -1;
        int frameLeft;
        int frameTop;
        int frameRight;
        int frameBottom;
        protected FixedSizeDataChunk strhChunk;
        protected FixedSizeDataChunk strfChunk;
        protected String name;
        protected Codec codec;
        protected Buffer outputBuffer;
        protected float videoQuality = 0.97f;
        protected IndexColorModel palette;
        protected IndexColorModel previousPalette;
        int planes;
        int bitCount;
        private int sampleChunkFourCC;

        public VideoTrack(int trackIndex, int fourCC, Format videoFormat) {
            this.twoCC = 48 + trackIndex / 10 << 24 | 48 + trackIndex % 10 << 16;
            this.fccHandler = fourCC;
            this.samples = new ArrayList();
            this.format = videoFormat;
            this.sampleChunkFourCC = videoFormat != null && videoFormat.get(FormatKey.EncodingKey).equals("DIB ") ? this.twoCC | 0x6462 : this.twoCC | 0x6463;
        }

        public long getSTRFChunkSize() {
            return this.palette == null ? 40L : (long)(40 + this.palette.getMapSize() * 4);
        }

        public int getSampleChunkFourCC() {
            return this.sampleChunkFourCC;
        }

        public void addSample(Sample s) {
            if (!this.samples.isEmpty()) {
                s.timeStamp = this.samples.get((int)(this.samples.size() - 1)).timeStamp + (long)this.samples.get((int)(this.samples.size() - 1)).duration;
            }
            this.samples.add(s);
            ++this.length;
        }
    }

    protected static class Sample {
        int chunkType;
        long offset;
        long length;
        int duration;
        boolean isKeyframe;
        long timeStamp;

        public Sample(int chunkId, int duration, long offset, long length, boolean isSync) {
            this.chunkType = chunkId;
            this.duration = duration;
            this.offset = offset;
            this.length = length;
            this.isKeyframe = isSync;
        }
    }

    protected static enum States {
        STARTED,
        FINISHED,
        CLOSED;

    }
}

