/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.videorecorder.VideoRecorderConfig;
import com.videorecorder.VideoRecorderPanel;
import com.videorecorder.video.avi.AVIWriter;
import com.videorecorder.video.format.Format;
import com.videorecorder.video.format.FormatKey;
import com.videorecorder.video.format.VideoFormatKeys;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Video Recorder", description="Capture the in-game screen as a video", tags={"video", "screencast", "capture", "movie", "AVI"})
public class VideoRecorderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VideoRecorderPlugin.class);
    private static final BufferedImage ICON = ImageUtil.loadImageResource(VideoRecorderPlugin.class, (String)"/panel_icon.png");
    private static final BufferedImage CURSOR = ImageUtil.loadImageResource(VideoRecorderPlugin.class, (String)"/cursor.png");
    private static final File CURSOR_CUSTOM = new File(RuneLite.RUNELITE_DIR, "cursor.png");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private static final String VIDEO_EXTENSION = ".avi";
    protected static final String VIDEO_RECORDER = "Video Recorder";
    protected static final File VIDEO_DIR = new File(RuneLite.RUNELITE_DIR, "videos");
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private DrawManager drawManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ScheduledExecutorService imageExecutor;
    @Inject
    private VideoRecorderConfig config;
    private boolean running;
    private boolean includeCursor;
    private boolean excludeLoginScreen;
    private boolean stopOnLogout;
    private boolean loggedOut;
    private boolean lastLoggedOut = true;
    private AVIWriter video;
    private BufferedImage cursor;
    private NavigationButton navButton;
    private VideoRecorderPanel panel;
    private ScheduledThreadPoolExecutor timerExecutor;
    private final HotkeyListener hotkeyStartListener = new HotkeyListener(() -> this.config.hotkeyStart()){

        public void hotkeyPressed() {
            if (!VideoRecorderPlugin.this.running) {
                VideoRecorderPlugin.this.panel.toggleVideo(true);
            } else if (VideoRecorderPlugin.this.config.hotkeyStart().equals((Object)VideoRecorderPlugin.this.config.hotkeyStop())) {
                VideoRecorderPlugin.this.panel.toggleVideo(false);
            }
        }
    };
    private final HotkeyListener hotkeyStopListener = new HotkeyListener(() -> this.config.hotkeyStop()){

        public void hotkeyPressed() {
            if (VideoRecorderPlugin.this.running) {
                VideoRecorderPlugin.this.panel.toggleVideo(false);
            }
        }
    };

    @Provides
    VideoRecorderConfig provideConfig(ConfigManager configManager) {
        return (VideoRecorderConfig)configManager.getConfig(VideoRecorderConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() throws Exception {
        VIDEO_DIR.mkdirs();
        this.includeCursor = this.config.includeCursor();
        this.excludeLoginScreen = this.config.excludeLoginScreen();
        this.stopOnLogout = this.config.stopOnLogout();
        if (CURSOR_CUSTOM.exists()) {
            try {
                Class<ImageIO> clazz = ImageIO.class;
                synchronized (ImageIO.class) {
                    this.cursor = ImageIO.read(CURSOR_CUSTOM);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                log.error("Error setting custom cursor", (Throwable)e);
            }
        } else {
            this.cursor = CURSOR;
        }
        {
            this.panel = (VideoRecorderPanel)((Object)this.injector.getInstance(VideoRecorderPanel.class));
            this.navButton = NavigationButton.builder().tooltip(VIDEO_RECORDER).icon(ICON).panel((PluginPanel)this.panel).priority(4).build();
            this.clientToolbar.addNavigation(this.navButton);
            this.keyManager.registerKeyListener((KeyListener)this.hotkeyStartListener);
            this.keyManager.registerKeyListener((KeyListener)this.hotkeyStopListener);
            return;
        }
    }

    protected void shutDown() throws Exception {
        if (this.running && this.video != null) {
            this.panel.toggleVideo(false);
        }
        this.clientToolbar.removeNavigation(this.navButton);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyStartListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyStopListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("videorecorder".equals(event.getGroup())) {
            this.includeCursor = this.config.includeCursor();
            this.excludeLoginScreen = this.config.excludeLoginScreen();
            this.stopOnLogout = this.config.stopOnLogout();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        boolean bl = this.loggedOut = GameState.LOGIN_SCREEN.equals((Object)gameState) || GameState.LOGIN_SCREEN_AUTHENTICATOR.equals((Object)gameState) || GameState.LOGGING_IN.equals((Object)gameState) || GameState.LOADING.equals((Object)gameState) && this.lastLoggedOut;
        if (this.stopOnLogout && this.loggedOut && !this.lastLoggedOut) {
            this.panel.toggleVideo(false);
        }
        this.lastLoggedOut = this.loggedOut;
    }

    protected void toggleVideo(boolean start) {
        if (start && !this.running) {
            this.video = null;
            this.running = true;
            this.timerExecutor = new ScheduledThreadPoolExecutor(1);
            int delay = 1000 / Math.max(1, Math.min(100, this.config.framerate()));
            this.timerExecutor.scheduleAtFixedRate(() -> {
                try {
                    if (this.running) {
                        if (!this.excludeLoginScreen || !this.loggedOut) {
                            Consumer<Image> imageCallback = img -> this.imageExecutor.submit(() -> this.screenshot((Image)img));
                            this.drawManager.requestNextFrameListener(imageCallback);
                        }
                    } else {
                        this.timerExecutor.shutdown();
                        this.timerExecutor.awaitTermination(2 * delay, TimeUnit.MILLISECONDS);
                        if (this.video != null) {
                            this.video.close();
                        }
                    }
                }
                catch (Throwable ex) {
                    log.warn("Error while writing video", ex);
                }
            }, 0L, delay, TimeUnit.MILLISECONDS);
        }
        if (!start && this.running) {
            this.running = false;
        }
    }

    private void screenshot(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (this.video != null) {
            Dimension videoSize = this.video.getVideoDimension(0);
            width = videoSize.width;
            height = videoSize.height;
        }
        BufferedImage frame = new BufferedImage(width, height, 1);
        Graphics2D graphics = frame.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        if (this.includeCursor) {
            Point position = this.client.getMouseCanvasPosition();
            int x = position.getX();
            int y = position.getY();
            if (x >= 0 && y >= 0) {
                graphics.drawImage((Image)this.cursor, x, y, null);
            }
        }
        graphics.dispose();
        try {
            if (this.video == null) {
                this.video = new AVIWriter(this.createOutputFile());
                Format videoFormat = new Format(new Object[]{FormatKey.MediaTypeKey, FormatKey.MediaType.VIDEO, FormatKey.FrameRateKey, Math.max(1, Math.min(100, this.config.framerate())), VideoFormatKeys.WidthKey, frame.getWidth(), VideoFormatKeys.HeightKey, frame.getHeight(), FormatKey.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 24, FormatKey.KeyFrameIntervalKey, Math.max(0, this.config.keyframeInterval()), VideoFormatKeys.CompressionLevelKey, Math.max(1, Math.min(9, this.config.compressionLevel()))});
                this.video.addVideoTrack(videoFormat);
                this.video.setPalette(0, frame.getColorModel());
            }
            this.video.write(0, frame);
        }
        catch (IOException ex) {
            log.warn("Error while writing video frame", (Throwable)ex);
        }
    }

    private File createOutputFile() {
        File playerFolder;
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
            Object playerDir = this.client.getLocalPlayer().getName();
            RuneScapeProfileType profileType = RuneScapeProfileType.getCurrent((Client)this.client);
            if (profileType != RuneScapeProfileType.STANDARD) {
                playerDir = (String)playerDir + "-" + Text.titleCase((Enum)profileType);
            }
            playerFolder = new File(VIDEO_DIR, (String)playerDir);
        } else {
            playerFolder = VIDEO_DIR;
        }
        playerFolder.mkdirs();
        String fileName = TIME_FORMAT.format(new Date());
        File videoFile = new File(playerFolder, fileName + VIDEO_EXTENSION);
        int i = 1;
        while (videoFile.exists()) {
            videoFile = new File(playerFolder, fileName + String.format("(%d)", i++) + VIDEO_EXTENSION);
        }
        return videoFile;
    }
}

