/*
 * Decompiled with CFR 0.152.
 */
package com.videorecorder;

import com.google.inject.Inject;
import com.videorecorder.VideoRecorderPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.LinkBrowser;

public class VideoRecorderPanel
extends PluginPanel {
    private final JButton startButton = new JButton("Start");
    private final JButton stopButton = new JButton("Stop");
    private final VideoRecorderPlugin plugin;

    @Inject
    VideoRecorderPanel(VideoRecorderPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(0, 1, 3, 10));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(new EmptyBorder(10, 0, 1, 0));
        JLabel title = new JLabel("Video Recorder");
        title.setForeground(Color.WHITE);
        this.startButton.setPreferredSize(new Dimension(0, 40));
        this.startButton.addActionListener(e -> this.toggleVideo(true));
        this.stopButton.addActionListener(e -> this.toggleVideo(false));
        this.stopButton.setEnabled(false);
        JButton outputButton = new JButton("Open output folder");
        outputButton.addActionListener(e -> LinkBrowser.open((String)VideoRecorderPlugin.VIDEO_DIR.toString()));
        topPanel.add(title);
        centerPanel.add(this.startButton);
        centerPanel.add(this.stopButton);
        bottomPanel.add(outputButton);
        this.add(topPanel, "North");
        this.add(centerPanel, "Center");
        this.add(bottomPanel, "South");
    }

    public void toggleVideo(boolean start) {
        this.plugin.toggleVideo(start);
        this.startButton.setEnabled(!start);
        this.stopButton.setEnabled(start);
    }
}

