/*
 * Decompiled with CFR 0.152.
 */
package com.ClanChatWarnings;

import com.ClanChatWarnings.CCWInputListener;
import com.ClanChatWarnings.ClanChatWarningsConfig;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.FriendsChatChanged;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PostMenuSort;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Chat Warnings")
public class ClanChatWarningsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanChatWarningsPlugin.class);
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();
    private static final String MESSAGE_DELIMITER = "~";
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message", (Object)"Add ignore", (Object)"Remove friend", (Object)"Kick");
    private final Map<Pattern, String> warnings = new HashMap<Pattern, String>();
    private final Map<String, String> warnPlayers = new HashMap<String, String>();
    private final Set<String> exemptPlayers = new HashSet<String>();
    private final Map<String, Instant> cooldownMap = new HashMap<String, Instant>();
    private final List<String> friendChatName = new ArrayList<String>();
    private boolean hopping;
    private int clanJoinedTick;
    private boolean hotKeyPressed;
    @Inject
    private Client client;
    @Inject
    private Notifier ping;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ClanChatWarningsConfig config;
    @Inject
    CCWInputListener hotKeyListener;
    @Inject
    KeyManager keyManager;

    protected void startUp() {
        this.updateSets();
        this.keyManager.registerKeyListener((KeyListener)this.hotKeyListener);
    }

    protected void shutDown() {
        this.warnings.clear();
        this.exemptPlayers.clear();
        this.warnPlayers.clear();
        this.cooldownMap.clear();
        this.friendChatName.clear();
        this.keyManager.unregisterKeyListener((KeyListener)this.hotKeyListener);
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.hotKeyPressed = false;
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.config.menu() && (this.hotKeyPressed || !this.config.shiftClick())) {
            int groupId = WidgetInfo.TO_GROUP((int)event.getActionParam1());
            String option = event.getOption();
            if (groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() && (option.equals("Add ignore") || option.equals("Remove friend")) || groupId == WidgetInfo.PRIVATE_CHAT_MESSAGE.getGroupId() && (option.equals("Add ignore") || option.equals("Message")) || groupId == WidgetInfo.CHATBOX.getGroupId() && (option.equals("Add ignore") || option.equals("Message"))) {
                this.client.createMenuEntry(1).setOption("Add to CC Warnings").setTarget(event.getTarget()).setType(MenuAction.RUNELITE).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier());
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equals("Add to CC Warnings")) {
            this.config.warnPlayers(this.config.warnPlayers() + ", " + Text.standardize((String)event.getMenuTarget()));
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", Text.removeTags((String)event.getMenuTarget()) + " has been added to Clan Chat Warnings.", "");
        }
    }

    void updateSets() {
        this.warnings.clear();
        this.exemptPlayers.clear();
        this.warnPlayers.clear();
        this.warnings.putAll(NEWLINE_SPLITTER.splitToList((CharSequence)this.config.warnings()).stream().map(s -> s.split(MESSAGE_DELIMITER)).collect(Collectors.toMap(p -> Pattern.compile(p[0].trim(), 2), p -> ((String[])p).length > 1 ? p[1].trim() : "")));
        this.exemptPlayers.addAll(Text.fromCSV((String)this.config.exemptPlayers()).stream().map(s -> s.toLowerCase().trim()).collect(Collectors.toSet()));
        this.warnPlayers.putAll(Text.fromCSV((String)this.config.warnPlayers()).stream().map(s -> s.split(MESSAGE_DELIMITER)).collect(Collectors.toMap(p -> p[0].toLowerCase().trim(), p -> ((String[])p).length > 1 ? p[1].trim() : "", (p1, p2) -> p1)));
    }

    private void sendNotification(String player, String Comment, int type) {
        StringBuilder stringBuilder = new StringBuilder();
        if (type == 1) {
            stringBuilder.append("has joined Friends Chat. ").append(Comment);
            String notification = stringBuilder.toString();
            if (this.config.kickable()) {
                this.client.addChatMessage(ChatMessageType.FRIENDSCHAT, player, notification, "Warning");
            } else {
                this.client.addChatMessage(ChatMessageType.FRIENDSCHATNOTIFICATION, "", player + " " + notification, "");
            }
            if (this.config.warnedAttention() && (this.clanJoinedTick != this.client.getTickCount() || this.config.selfPing())) {
                this.ping.notify(player + " " + notification);
            }
        }
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined event) {
        if (this.clanJoinedTick != this.client.getTickCount()) {
            this.hopping = false;
        }
        if (this.clanJoinedTick != this.client.getTickCount() || this.config.selfCheck() && !this.hopping) {
            String localName;
            FriendsChatMember member = event.getMember();
            String memberName = this.toTrueName(member.getName().trim());
            String string = localName = this.client.getLocalPlayer() == null ? null : this.client.getLocalPlayer().getName();
            if (memberName == null || memberName.equalsIgnoreCase(localName) && !this.config.selfCheck()) {
                return;
            }
            String warningMessage = this.getWarningMessageByUsername(memberName);
            if (warningMessage != null) {
                if (this.config.cooldown() > 0) {
                    this.cooldownMap.put(memberName.toLowerCase(), Instant.now());
                }
                this.sendNotification(memberName, warningMessage, 1);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("ClanChatPlus")) {
            this.updateSets();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.HOPPING) {
            this.hopping = true;
        }
    }

    @Subscribe
    public void onFriendsChatChanged(FriendsChatChanged event) {
        if (event.isJoined()) {
            this.clanJoinedTick = this.client.getTickCount();
        }
    }

    @Provides
    ClanChatWarningsConfig provideConfig(ConfigManager configManager) {
        return (ClanChatWarningsConfig)configManager.getConfig(ClanChatWarningsConfig.class);
    }

    @Nullable
    private String getWarningMessageByUsername(String username) {
        if (this.exemptPlayers.contains(username = username.toLowerCase())) {
            return null;
        }
        if (this.cooldownMap.containsKey(username)) {
            Instant cutoff = Instant.now().minus(this.config.cooldown(), ChronoUnit.SECONDS);
            if (cutoff.compareTo(this.cooldownMap.get(username)) > 0) {
                this.cooldownMap.remove(username);
            } else {
                return null;
            }
        }
        if (this.warnPlayers.containsKey(username)) {
            return this.warnPlayers.get(username);
        }
        for (Map.Entry<Pattern, String> entry : this.warnings.entrySet()) {
            Matcher m = entry.getKey().matcher(username);
            if (!m.find()) continue;
            return entry.getValue();
        }
        return null;
    }

    private String toTrueName(String str) {
        return CharMatcher.ascii().retainFrom((CharSequence)str.replace('\u00a0', ' ')).trim();
    }

    @Subscribe(priority=-2.0f)
    public void onPostMenuSort(PostMenuSort e) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length == 0) {
            return;
        }
        for (MenuEntry entry : menuEntries) {
            String target;
            if (!entry.getType().equals((Object)MenuAction.CC_OP_LOW_PRIORITY) || !entry.getOption().equalsIgnoreCase("kick") && !entry.getOption().equalsIgnoreCase("kick user") || !this.warnPlayers.containsKey(target = Text.standardize((String)entry.getTarget()))) continue;
            entry.setType(MenuAction.CC_OP);
            this.client.setMenuEntries(new MenuEntry[]{entry});
        }
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }
}

