/*
 * Decompiled with CFR 0.152.
 */
package com.pappymint.namedpets;

import com.google.inject.Provides;
import com.pappymint.namedpets.NamedPetsConfig;
import com.pappymint.namedpets.NamedPetsConfigManager;
import com.pappymint.namedpets.NamedPetsOverlay;
import java.applet.Applet;
import java.awt.Color;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.MenuOpened;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Named Pets", description="Right click & name your fluffy friend!", tags={"pet"})
public class NamedPetsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NamedPetsPlugin.class);
    private NamedPetsConfigManager pluginConfigManager;
    @Inject
    private Client client;
    @Inject
    private NamedPetsConfig config;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NamedPetsOverlay petNameOverlay;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ColorPickerManager colorPickerManager;

    protected void startUp() throws Exception {
        this.pluginConfigManager = new NamedPetsConfigManager(this, this.configManager);
        this.overlayManager.add((Overlay)this.petNameOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.petNameOverlay);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened menuOpened) {
        this.checkIfMenuOptionsBelongToFollower(menuOpened.getMenuEntries());
    }

    private void checkIfMenuOptionsBelongToFollower(MenuEntry[] menuEntries) {
        NPC myFollowerNPC = this.client.getFollower();
        if (myFollowerNPC == null) {
            return;
        }
        for (int entryIndex = 0; entryIndex < menuEntries.length; ++entryIndex) {
            MenuEntry entry = menuEntries[entryIndex];
            NPC targetedNpc = entry.getNpc();
            if (targetedNpc == null || targetedNpc.getId() != myFollowerNPC.getId()) continue;
            this.addNamePetMenuOption(targetedNpc, entryIndex, entry);
            this.addColorNameMenuOption(targetedNpc, entryIndex, entry);
            break;
        }
    }

    private void addNamePetMenuOption(NPC pet, int index, MenuEntry menuEntry) {
        this.client.createMenuEntry(index).setOption("Name").setTarget(menuEntry.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.onNameMenuEntryOptionClicked(pet));
    }

    private void addColorNameMenuOption(NPC pet, int index, MenuEntry menuEntry) {
        if (!this.getExistingPetName(pet.getId()).isEmpty()) {
            MenuEntry nameColorEntry = this.client.createMenuEntry(index).setOption("Color Name").setTarget(menuEntry.getTarget()).setType(MenuAction.RUNELITE_SUBMENU);
            this.client.createMenuEntry(index).setOption("Pick").setParent(nameColorEntry).setType(MenuAction.RUNELITE).onClick(e -> {
                Color existingColor = this.getExistingPetNameColor(pet.getId());
                SwingUtilities.invokeLater(() -> {
                    RuneliteColorPicker colorPicker = this.colorPickerManager.create(SwingUtilities.windowForComponent((Applet)this.client), existingColor, "Pet Name Color", false);
                    colorPicker.setOnClose(color -> this.saveNameColor(pet.getId(), (Color)color));
                    colorPicker.setVisible(true);
                });
            });
        }
    }

    private void onNameMenuEntryOptionClicked(NPC pet) {
        this.chatboxPanelManager.openTextInput("Name your " + pet.getName()).value(this.getExistingPetName(pet.getId())).onDone(input -> this.savePetName(pet, (String)input)).build();
    }

    private void savePetName(NPC petNpc, String petName) {
        if (Objects.equals(petName, "") || petName == null) {
            this.pluginConfigManager.unsetPetName(petNpc.getId());
        } else {
            this.pluginConfigManager.setPetName(petNpc.getId(), petName);
            this.pluginConfigManager.setPetNPCName(petNpc.getId(), petNpc.getName());
        }
    }

    private String getExistingPetName(int petNpcId) {
        String name = this.pluginConfigManager.getSavedPetName(petNpcId);
        if (name != null) {
            return name;
        }
        return "";
    }

    private void saveNameColor(int petNpcId, Color nameColor) {
        this.pluginConfigManager.setPetColor(petNpcId, nameColor);
    }

    private Color getExistingPetNameColor(int petNpcId) {
        String savedColor = this.pluginConfigManager.getSavedPetColor(petNpcId);
        if (savedColor != null) {
            return Color.decode(savedColor);
        }
        return Color.white;
    }

    @Provides
    NamedPetsConfig provideConfig(ConfigManager configManager) {
        return (NamedPetsConfig)configManager.getConfig(NamedPetsConfig.class);
    }
}

