/*
 * Decompiled with CFR 0.152.
 */
package com.pappymint.namedpets;

import com.pappymint.namedpets.NamedPetsConfig;
import com.pappymint.namedpets.NamedPetsConfigManager;
import com.pappymint.namedpets.NamedPetsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class NamedPetsOverlay
extends Overlay {
    private final NamedPetsConfig pluginConfig;
    private final NamedPetsPlugin plugin;
    private final NamedPetsConfigManager configManager;
    @Inject
    private Client client;

    @Inject
    private NamedPetsOverlay(NamedPetsPlugin plugin, NamedPetsConfig pluginConfig, NamedPetsConfigManager configManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.pluginConfig = pluginConfig;
        this.configManager = configManager;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        NPC follower = this.client.getFollower();
        if (follower == null) {
            return null;
        }
        this.renderFollowingPetName(graphics, (Actor)follower, follower.getId());
        return null;
    }

    private void renderFollowingPetName(Graphics2D graphics, Actor petActor, int petId) {
        String followingPetName = this.configManager.getSavedPetName(petId);
        Color nameColor = this.getPetNameColor(petId);
        int customHeightIncrease = this.pluginConfig.getCustomPosition() > 0 && this.pluginConfig.getCustomPosition() <= 100 ? this.pluginConfig.getCustomPosition() : 0;
        Point petNameLocation = petActor.getCanvasTextLocation(graphics, followingPetName, petActor.getModelHeight() + customHeightIncrease);
        if (petNameLocation != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)petNameLocation, (String)followingPetName, (Color)nameColor);
        }
    }

    private Color getPetNameColor(int petId) {
        String customColorSetForPet = this.configManager.getSavedPetColor(petId);
        Color defaultConfigColor = this.pluginConfig.getDefaultPetNameColor();
        if (customColorSetForPet != null) {
            return Color.decode(customColorSetForPet);
        }
        if (defaultConfigColor != null) {
            return defaultConfigColor;
        }
        return Color.white;
    }
}

