/*
 * Decompiled with CFR 0.152.
 */
package com.pappymint.namedpets;

import com.pappymint.namedpets.NamedPetsPlugin;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;

public class NamedPetsConfigManager {
    private final ConfigManager configManager;
    private final NamedPetsPlugin plugin;
    public static final String CONFIG_GROUP = "namedPets";
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_COLOR = "color";
    public static final String CONFIG_NPC_NAME = "npcName";

    @Inject
    NamedPetsConfigManager(NamedPetsPlugin plugin, ConfigManager configManager) {
        this.configManager = configManager;
        this.plugin = plugin;
    }

    private String nameConfigKey(int petId) {
        return "name-" + petId;
    }

    private String colorConfigKey(int petId) {
        return "color-" + petId;
    }

    private String npcNameConfigKey(int petId) {
        return "npcName-" + petId;
    }

    public String getSavedPetName(int petId) {
        return this.configManager.getRSProfileConfiguration(CONFIG_GROUP, this.nameConfigKey(petId));
    }

    public void setPetName(int petId, String petName) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, this.nameConfigKey(petId), (Object)petName);
    }

    public void unsetPetName(int petId) {
        this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP, this.nameConfigKey(petId));
    }

    public String getSavedPetColor(int petId) {
        return this.configManager.getRSProfileConfiguration(CONFIG_GROUP, this.colorConfigKey(petId));
    }

    public void setPetColor(int petId, Color petNameColor) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, this.colorConfigKey(petId), (Object)petNameColor);
    }

    public String getPetNPCName(int petId) {
        return this.configManager.getRSProfileConfiguration(CONFIG_GROUP, this.npcNameConfigKey(petId));
    }

    public void setPetNPCName(int petId, String npcName) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP, this.npcNameConfigKey(petId), (Object)npcName);
    }
}

