/*
 * Decompiled with CFR 0.152.
 */
package com.statussocket.data.player;

import com.statussocket.data.PacketTypes;
import com.statussocket.data.player.AttackPacket;
import com.statussocket.data.player.CameraPacket;
import com.statussocket.data.player.EquipmentPacket;
import com.statussocket.data.player.EquipmentStatsPacket;
import com.statussocket.data.player.InventoryPacket;
import com.statussocket.data.player.LocalPointPacket;
import com.statussocket.data.player.PlayerDataPacket;
import com.statussocket.data.player.SkillPacket;
import com.statussocket.data.player.WorldPointPacket;
import com.statussocket.models.AnimationData;
import com.statussocket.models.EquipmentData;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;

public class PlayerDataBuilder {
    private static Skill[] COMBAT_SKILLS = new Skill[]{Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.RANGED, Skill.MAGIC, Skill.HITPOINTS, Skill.PRAYER};
    private static String UNKNOWN_ANIMATION_STR = "N/A";
    private Client client;
    private ItemManager itemManager;
    private String targetName;
    private boolean isAttacking;
    private String packetType;
    private PlayerDataPacket pdp;

    public PlayerDataBuilder(Client client, ItemManager itemManager) {
        this.client = client;
        this.itemManager = itemManager;
        this.pdp = null;
        this.packetType = PacketTypes.inventory.name();
    }

    public PlayerDataBuilder(Client client, ItemManager itemManager, String targetName, boolean isAttacking) {
        this.client = client;
        this.itemManager = itemManager;
        this.targetName = targetName;
        this.isAttacking = isAttacking;
        this.pdp = null;
        this.packetType = isAttacking ? PacketTypes.attacking.name() : PacketTypes.defending.name();
    }

    private void loadInventory() {
        ItemContainer ic = this.client.getItemContainer(InventoryID.INVENTORY);
        if (ic == null) {
            this.pdp.inventory = new InventoryPacket[0];
            return;
        }
        Item[] items = ic.getItems();
        if (items == null || items.length == 0) {
            this.pdp.inventory = new InventoryPacket[0];
            return;
        }
        int validItems = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getId() <= 0) continue;
            ++validItems;
        }
        this.pdp.inventory = new InventoryPacket[validItems];
        int index = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getId() <= 0) continue;
            this.pdp.inventory[index] = new InventoryPacket(i, items[i]);
            ++index;
        }
    }

    private void loadEquipment() {
        ItemContainer ic = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (ic == null) {
            this.pdp.equipment = new EquipmentPacket[0];
            return;
        }
        Item[] items = ic.getItems();
        if (items == null || items.length == 0) {
            this.pdp.equipment = new EquipmentPacket[0];
            return;
        }
        int validItems = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getId() <= 0) continue;
            ++validItems;
        }
        this.pdp.equipment = new EquipmentPacket[validItems];
        int index = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getId() <= 0) continue;
            EquipmentData itemData = EquipmentData.fromId(items[i].getId());
            String itemName = itemData != null ? itemData.name() : this.itemManager.getItemComposition(items[i].getId()).getName();
            this.pdp.equipment[index] = new EquipmentPacket(i, items[i], itemName);
            ++index;
        }
    }

    private void loadEquipmentStats() {
        if (this.pdp.equipment.length < 1) {
            this.pdp.equipmentStats = new EquipmentStatsPacket();
            return;
        }
        ItemEquipmentStats[] itemEquipmentStats = new ItemEquipmentStats[this.pdp.equipment.length];
        for (int i = 0; i < this.pdp.equipment.length; ++i) {
            EquipmentData itemData;
            int itemId = this.pdp.equipment[i].id;
            ItemStats itemStats = this.itemManager.getItemStats(itemId, false);
            if (itemStats == null && (itemData = EquipmentData.fromId(itemId)) != null) {
                itemId = itemData.getItemId();
                itemStats = this.itemManager.getItemStats(itemId, false);
            }
            itemEquipmentStats[i] = itemStats != null ? itemStats.getEquipment() : null;
        }
        this.pdp.equipmentStats = new EquipmentStatsPacket(itemEquipmentStats);
    }

    private void loadSkills() {
        this.pdp.skills = new SkillPacket[COMBAT_SKILLS.length];
        for (int i = 0; i < COMBAT_SKILLS.length; ++i) {
            this.pdp.skills[i] = new SkillPacket();
            this.pdp.skills[i].skillName = COMBAT_SKILLS[i].name();
            this.pdp.skills[i].experience = this.client.getSkillExperience(COMBAT_SKILLS[i]);
            this.pdp.skills[i].boostedLevel = this.client.getBoostedSkillLevel(COMBAT_SKILLS[i]);
            this.pdp.skills[i].realLevel = this.client.getRealSkillLevel(COMBAT_SKILLS[i]);
        }
    }

    private void loadPrayers() {
        int count = 0;
        for (Prayer prayer : Prayer.values()) {
            if (!this.client.isPrayerActive(prayer)) continue;
            ++count;
        }
        this.pdp.prayers = new String[count];
        int index = 0;
        for (Prayer prayer : Prayer.values()) {
            if (!this.client.isPrayerActive(prayer)) continue;
            this.pdp.prayers[index] = prayer.name();
            ++index;
        }
    }

    private void loadLocation() {
        Player p = this.client.getLocalPlayer();
        LocalPoint ll = p.getLocalLocation();
        this.pdp.localPoint = new LocalPointPacket();
        this.pdp.localPoint.x = ll.getX();
        this.pdp.localPoint.y = ll.getY();
        this.pdp.localPoint.sceneX = ll.getSceneX();
        this.pdp.localPoint.sceneY = ll.getSceneY();
        WorldPoint wl = p.getWorldLocation();
        this.pdp.worldPoint = new WorldPointPacket();
        this.pdp.worldPoint.x = wl.getX();
        this.pdp.worldPoint.y = wl.getY();
        this.pdp.worldPoint.plane = wl.getPlane();
        this.pdp.worldPoint.regionID = wl.getRegionID();
        this.pdp.worldPoint.regionX = wl.getRegionX();
        this.pdp.worldPoint.regionY = wl.getRegionY();
        this.pdp.camera = new CameraPacket();
        this.pdp.camera.yaw = this.client.getCameraYaw();
        this.pdp.camera.pitch = this.client.getCameraPitch();
        this.pdp.camera.x = this.client.getCameraX();
        this.pdp.camera.y = this.client.getCameraY();
        this.pdp.camera.z = this.client.getCameraZ();
        this.pdp.camera.x2 = this.client.getCameraX2();
        this.pdp.camera.y2 = this.client.getCameraY2();
        this.pdp.camera.z2 = this.client.getCameraZ2();
    }

    private void loadAttack() {
        this.pdp.attack = new AttackPacket();
        this.pdp.attack.targetName = this.targetName;
        this.pdp.attack.isAttacking = this.isAttacking;
        this.pdp.attack.animationId = this.client.getLocalPlayer().getAnimation();
        AnimationData animationData = AnimationData.fromId(this.client.getLocalPlayer().getAnimation());
        if (animationData == null) {
            this.pdp.attack.animationName = UNKNOWN_ANIMATION_STR;
            return;
        }
        this.pdp.attack.animationName = animationData.name();
        this.pdp.attack.animationIsSpecial = animationData.isSpecial();
        this.pdp.attack.animationAttackStyle = animationData.getAttackStyle().name();
        this.pdp.attack.animationBaseSpellDmg = animationData.getBaseSpellDamage();
    }

    public PlayerDataPacket build() {
        if (this.pdp == null) {
            this.pdp = new PlayerDataPacket();
            this.pdp.tick = this.client.getTickCount();
            this.pdp.packetType = this.packetType != null ? this.packetType : PacketTypes.unknown.name();
            this.pdp.playerName = this.client.getLocalPlayer().getName();
            this.pdp.runEnergy = this.client.getEnergy();
            this.pdp.specialAttack = this.client.getVarbitValue(300);
            this.loadInventory();
            this.loadEquipment();
            this.loadEquipmentStats();
            this.loadSkills();
            this.loadPrayers();
            this.loadLocation();
            this.loadAttack();
        }
        return this.pdp;
    }
}

