/*
 * Decompiled with CFR 0.152.
 */
package com.statussocket;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.statussocket.StatusSocketClient;
import com.statussocket.StatusSocketConfig;
import com.statussocket.models.AnimationData;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Status Socket", description="Actively logs the player status to a remote server.", tags={"status", "socket"})
public class StatusSocketPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StatusSocketPlugin.class);
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Gson gson;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private StatusSocketConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    private StatusSocketClient slc;
    private int lastTickAttacked;

    @Provides
    StatusSocketConfig provideConfig(ConfigManager configManager) {
        return (StatusSocketConfig)configManager.getConfig(StatusSocketConfig.class);
    }

    protected void startUp() {
        this.slc = new StatusSocketClient(this.client, this.httpClient, this.gson, this.itemManager, this.config);
    }

    protected void shutDown() {
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        Player player = this.client.getLocalPlayer();
        Actor actor = event.getActor();
        Hitsplat hitsplat = event.getHitsplat();
        if (player == null || actor == null || hitsplat == null || !hitsplat.isMine() || Objects.equals(actor.getName(), player.getName())) {
            return;
        }
        if (actor instanceof Player) {
            Player target = (Player)actor;
            String targetName = target.getName();
            this.clientThread.invokeLater(() -> this.slc.sendHitsplat(hitsplat.getAmount(), targetName));
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        this.clientThread.invokeLater(() -> {
            Player player = this.client.getLocalPlayer();
            Actor actor = event.getActor();
            if (player == null || !(actor instanceof Player)) {
                return;
            }
            boolean isAttacking = Objects.equals(actor.getName(), player.getName());
            if (isAttacking) {
                return;
            }
            Actor target = actor.getInteracting();
            if (!(target instanceof Player) || !Objects.equals(target.getName(), player.getName())) {
                return;
            }
            int animationId = actor.getAnimation();
            if (animationId == -1) {
                return;
            }
            AnimationData animationData = AnimationData.fromId(animationId);
            if (animationData == null) {
                return;
            }
            this.slc.sendCombatLog(actor.getName(), false);
        });
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            this.slc.sendInventoryChangeLog();
            return;
        }
        Actor target = player.getInteracting();
        if (!(target instanceof Player)) {
            this.slc.sendInventoryChangeLog();
            return;
        }
        int animationId = player.getAnimation();
        if (animationId == -1) {
            this.slc.sendInventoryChangeLog();
            return;
        }
        AnimationData animationData = AnimationData.fromId(animationId);
        if (animationData == null) {
            this.slc.sendInventoryChangeLog();
            return;
        }
        if (this.lastTickAttacked == this.client.getTickCount()) {
            this.slc.sendInventoryChangeLog();
            return;
        }
        this.slc.sendCombatLog(target.getName(), true);
        this.lastTickAttacked = this.client.getTickCount();
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        Player player = this.client.getLocalPlayer();
        Actor actor = event.getActor();
        if (player == null || !(actor instanceof Player)) {
            return;
        }
        this.slc.sendDeath(actor.getName());
    }

    public Client getClient() {
        return this.client;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }
}

