/*
 * Decompiled with CFR 0.152.
 */
package com.statussocket;

import com.google.gson.Gson;
import com.statussocket.StatusSocketConfig;
import com.statussocket.StatusSocketEndpoints;
import com.statussocket.data.death.DeathBuilder;
import com.statussocket.data.hitsplat.HitsplatBuilder;
import com.statussocket.data.player.PlayerDataBuilder;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusSocketClient {
    private static final Logger log = LoggerFactory.getLogger(StatusSocketClient.class);
    @Inject
    private Client client;
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Gson gson;
    private ItemManager itemManager;
    private StatusSocketConfig config;

    public void sendHitsplat(int damage, String targetName) {
        HitsplatBuilder builder = new HitsplatBuilder(this.client);
        builder.setDamage(damage);
        builder.setTargetName(targetName != null ? targetName : "");
        this.post(builder.build());
    }

    public void sendInventoryChangeLog() {
        PlayerDataBuilder builder = new PlayerDataBuilder(this.client, this.itemManager);
        this.post(builder.build());
    }

    public void sendCombatLog(String targetName, boolean isAttacking) {
        PlayerDataBuilder builder = new PlayerDataBuilder(this.client, this.itemManager, targetName, isAttacking);
        this.post(builder.build());
    }

    public void sendDeath(String targetName) {
        DeathBuilder builder = new DeathBuilder(this.client);
        builder.setTargetName(targetName != null ? targetName : "");
        this.post(builder.build());
    }

    private void post(Object obj) {
        Gson gson = this.gson.newBuilder().serializeNulls().create();
        String json = gson.toJson(obj);
        Object endpoint = this.config.endpoint().endsWith("/") ? this.config.endpoint() : this.config.endpoint() + "/";
        HttpUrl url = HttpUrl.parse((String)((String)endpoint + StatusSocketEndpoints.LOG_ENDPOINT));
        MediaType mt = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)mt, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (StatusSocketClient.this.config.enableLogs()) {
                    log.warn("httpClient failure " + e.getMessage().toString());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (StatusSocketClient.this.config.enableLogs()) {
                    log.info("Code: {} - Response: {}", (Object)response.code(), (Object)response.body().string());
                }
                response.close();
            }
        });
    }

    public StatusSocketClient(Client client, OkHttpClient httpClient, Gson gson, ItemManager itemManager, StatusSocketConfig config) {
        this.client = client;
        this.httpClient = httpClient;
        this.gson = gson;
        this.itemManager = itemManager;
        this.config = config;
    }
}

