/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletcalculator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.util.ImageUtil;

public class GauntletCalculatorPanel
extends PluginPanel {
    private int shardCount = 0;
    private int oreCount = 0;
    private int linumCount = 0;
    private int phrenCount = 0;
    private int frameCount = 0;
    private int weaponCount = 0;
    private int grymCount = 0;
    private JComboBox weapon1Combo = new JComboBox();
    private JComboBox weapon2Combo = new JComboBox();
    private JComboBox helmCombo = new JComboBox();
    private JComboBox chestCombo = new JComboBox();
    private JComboBox legsCombo = new JComboBox();
    private FlatTextField escapeText = new FlatTextField();
    private FlatTextField teleportText = new FlatTextField();
    private FlatTextField potionText = new FlatTextField();
    private JPanel itemPanel = new JPanel();
    private String[] types = new String[]{"None", "Basic", "Attuned", "Perfected"};

    @Inject
    private GauntletCalculatorPanel() {
        this.setPreferredSize(new Dimension(200, 800));
        this.add(this.createTitleLabel("Gauntlet Calculator"));
        this.styleBoxes();
        this.itemPanel.setLayout(new GridLayout(0, 4));
        this.itemPanel.setPreferredSize(new Dimension(200, 100));
        this.setItemPanel();
        this.weapon1Combo.setModel(new DefaultComboBoxModel<String>(this.types));
        this.weapon2Combo.setModel(new DefaultComboBoxModel<String>(this.types));
        this.helmCombo.setModel(new DefaultComboBoxModel<String>(this.types));
        this.chestCombo.setModel(new DefaultComboBoxModel<String>(this.types));
        this.legsCombo.setModel(new DefaultComboBoxModel<String>(this.types));
        this.weapon1Combo.setSelectedIndex(0);
        this.weapon2Combo.setSelectedIndex(0);
        this.helmCombo.setSelectedIndex(0);
        this.chestCombo.setSelectedIndex(0);
        this.legsCombo.setSelectedIndex(0);
        this.add(this.getWeapon1());
        this.add(this.weapon1Combo);
        this.add(this.getWeapon2());
        this.add(this.weapon2Combo);
        this.add(this.getHelm());
        this.add(this.helmCombo);
        this.add(this.getBody());
        this.add(this.chestCombo);
        this.add(this.getLegs());
        this.add(this.legsCombo);
        this.add(this.getPotion());
        this.add((Component)this.potionText);
        this.add(this.getTeleport());
        this.add((Component)this.teleportText);
        this.add(this.getEscape());
        this.add((Component)this.escapeText);
        this.add(this.createEnterButton());
        this.add(this.itemPanel);
    }

    private JLabel createTitleLabel(String title) {
        JLabel label = new JLabel(title, 0);
        label.setPreferredSize(new Dimension(200, 20));
        label.setForeground(Color.yellow);
        return label;
    }

    private void styleBoxes() {
        this.weapon1Combo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.weapon2Combo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.helmCombo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.chestCombo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.legsCombo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.escapeText.setPreferredSize(new Dimension(205, 30));
        this.escapeText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.escapeText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.escapeText.setText("0");
        this.teleportText.setPreferredSize(new Dimension(205, 30));
        this.teleportText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.teleportText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.teleportText.setText("0");
        this.potionText.setPreferredSize(new Dimension(205, 30));
        this.potionText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.potionText.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.potionText.setText("0");
    }

    private JLabel getWeapon1() {
        JLabel label = new JLabel();
        label.setToolTipText("Weapon 1");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Weapon 1");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Crystal_halberd_(perfected).png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getWeapon2() {
        JLabel label = new JLabel();
        label.setToolTipText("Weapon 2");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Weapon 2");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Crystal_bow_(perfected).png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getHelm() {
        JLabel label = new JLabel();
        label.setToolTipText("Helm");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Helm");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Crystal_helm_(perfected).png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getBody() {
        JLabel label = new JLabel();
        label.setToolTipText("Chest");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Chest Tier");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Crystal_body_(perfected).png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getLegs() {
        JLabel label = new JLabel();
        label.setToolTipText("Legs");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Legs Tier");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Crystal_legs_(perfected).png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getEscape() {
        JLabel label = new JLabel();
        label.setToolTipText("Escape");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Escape Crystals");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Escape_crystal.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getTeleport() {
        JLabel label = new JLabel();
        label.setToolTipText("Teleport");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Teleport Crystals");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Teleport_crystal.png")));
        label.setIconTextGap(10);
        return label;
    }

    private JLabel getPotion() {
        JLabel label = new JLabel();
        label.setToolTipText("Potion");
        label.setFont(FontManager.getRunescapeFont());
        label.setText("Egniol Potions");
        label.setForeground(Color.yellow);
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Vial.png")));
        label.setIconTextGap(10);
        return label;
    }

    private void setItemPanel() {
        this.itemPanel.removeAll();
        this.itemPanel.add(this.createItemLabel("Crystal_shard_1", String.valueOf(this.shardCount)));
        this.itemPanel.add(this.createItemLabel("Crystal_ore", String.valueOf(this.oreCount)));
        this.itemPanel.add(this.createItemLabel("Linum_tirinum", String.valueOf(this.linumCount)));
        this.itemPanel.add(this.createItemLabel("Phren_bark", String.valueOf(this.phrenCount)));
        this.itemPanel.add(this.createItemLabel("Grym_leaf", String.valueOf(this.grymCount)));
        this.itemPanel.add(this.createItemLabel("Weapon_frame", String.valueOf(this.frameCount)));
        this.itemPanel.add(this.createItemLabel("Crystal_spike", String.valueOf(this.weaponCount)));
    }

    private JLabel createItemLabel(String name, String qty) {
        JLabel label = new JLabel();
        label.setToolTipText(name);
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR));
        ImageIcon icon = new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)(name + ".png")));
        label.setIcon(this.getLabeledIcon(icon, qty));
        return label;
    }

    private Icon getLabeledIcon(Icon old, String qty) {
        int w = old.getIconWidth();
        int h = old.getIconHeight();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2d = img.createGraphics();
        old.paintIcon(null, g2d, 0, 0);
        g2d.setPaint(Color.white);
        g2d.drawString(qty, 0, 10);
        g2d.dispose();
        return new ImageIcon(img.getScaledInstance(w, h, 4));
    }

    private JButton createEnterButton() {
        final JButton label = new JButton("Calculate");
        label.setPreferredSize(new Dimension(205, 30));
        label.setFocusable(false);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    label.setText("Wait...");
                    GauntletCalculatorPanel.this.runCalculation();
                    GauntletCalculatorPanel.this.setItemPanel();
                    label.setText("Calculate");
                }
            }
        });
        return label;
    }

    private void runCalculation() {
        int teleportX;
        int potionX;
        int escapeX;
        try {
            escapeX = Integer.parseInt(this.escapeText.getText());
        }
        catch (Exception e) {
            escapeX = 0;
            this.escapeText.setText("0");
        }
        try {
            potionX = Integer.parseInt(this.potionText.getText());
        }
        catch (Exception e) {
            potionX = 0;
            this.potionText.setText("0");
        }
        try {
            teleportX = Integer.parseInt(this.teleportText.getText());
        }
        catch (Exception e) {
            teleportX = 0;
            this.teleportText.setText("0");
        }
        this.shardCount = 0;
        this.oreCount = 0;
        this.linumCount = 0;
        this.phrenCount = 0;
        this.frameCount = 0;
        this.weaponCount = 0;
        this.grymCount = 0;
        switch (this.weapon1Combo.getSelectedIndex()) {
            case 3: {
                ++this.weaponCount;
            }
            case 2: {
                this.shardCount += 60;
            }
            case 1: {
                this.shardCount += 20;
                ++this.frameCount;
            }
        }
        switch (this.weapon2Combo.getSelectedIndex()) {
            case 3: {
                ++this.weaponCount;
            }
            case 2: {
                this.shardCount += 60;
            }
            case 1: {
                this.shardCount += 20;
                ++this.frameCount;
            }
        }
        switch (this.helmCombo.getSelectedIndex()) {
            case 3: {
                this.shardCount += 80;
                this.oreCount += 2;
                this.phrenCount += 2;
                this.linumCount += 2;
            }
            case 2: {
                this.shardCount += 60;
                ++this.oreCount;
                ++this.phrenCount;
                ++this.linumCount;
            }
            case 1: {
                this.shardCount += 40;
                ++this.oreCount;
                ++this.phrenCount;
                ++this.linumCount;
            }
        }
        switch (this.chestCombo.getSelectedIndex()) {
            case 3: {
                this.shardCount += 80;
                this.oreCount += 2;
                this.phrenCount += 2;
                this.linumCount += 2;
            }
            case 2: {
                this.shardCount += 60;
                this.oreCount += 2;
                this.phrenCount += 2;
                this.linumCount += 2;
            }
            case 1: {
                this.shardCount += 40;
                ++this.oreCount;
                ++this.phrenCount;
                ++this.linumCount;
            }
        }
        switch (this.legsCombo.getSelectedIndex()) {
            case 3: {
                this.shardCount += 80;
                this.oreCount += 2;
                this.phrenCount += 2;
                this.linumCount += 2;
            }
            case 2: {
                this.shardCount += 60;
                ++this.oreCount;
                ++this.phrenCount;
                ++this.linumCount;
            }
            case 1: {
                this.shardCount += 40;
                ++this.oreCount;
                ++this.phrenCount;
                ++this.linumCount;
            }
        }
        this.shardCount += escapeX * 200;
        this.grymCount += potionX;
        this.shardCount += potionX * 20;
        this.shardCount += teleportX * 40;
    }
}

